/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.exceptions.RfcException;

public class TableDeltaLogEntry {
    static final int LOG_OBJECT_CONFIRM = 0;
    static final int LOG_OBJECT_REJECT = 1;
    static final int LOG_PLAYBACK_START = 2;
    static final int LOG_PLAYBACK_END = 3;
    public static final int LOG_ITAB_APPEND = 4;
    public static final int LOG_ITAB_DELETE = 5;
    public static final int LOG_ITAB_INSERT = 6;
    public static final int LOG_ITAB_UPDATE = 7;
    public static final int LOG_ITAB_FREE = 8;
    static final int LOG_ITAB_DISCARD = 9;
    public static final int LOG_ITAB_REBUILD = 10;
    public static final int LOG_ITAB_CORRECTION = 11;
    static final int LOG_ITAB_POP = 12;
    public int operation;
    public int objId;
    public int line;
    byte[] deltaLogBuffer = new byte[12];

    void readFromBuffer() {
        this.operation = RfcUtilities.byteArrayToInt(this.deltaLogBuffer, 0);
        this.objId = RfcUtilities.byteArrayToInt(this.deltaLogBuffer, 4);
        this.line = RfcUtilities.byteArrayToInt(this.deltaLogBuffer, 8);
    }

    void playback(IRfcTable table, byte[] rfcData) throws RfcException {
        switch (this.operation) {
            case 4: {
                table.appendRow(rfcData);
                break;
            }
            case 5: {
                table.deleteRow(this.line - 1);
                break;
            }
            case 6: {
                table.insertRow(this.line - 1);
                table.setBytes(this.line - 1, rfcData);
                break;
            }
            case 7: 
            case 11: {
                table.setBytes(this.line - 1, rfcData);
                break;
            }
            case 8: {
                table.clear();
                break;
            }
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                throw new RfcException(1, "Unexpected delta operation " + this.operation, 108, 0L, false);
            }
            default: {
                throw new RfcException(1, "Unknown delta operation " + this.operation, 108, 0L, false);
            }
        }
    }
}

