/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class Trc {
    private static RfcTraceWriter m_trc = RfcApi.runtime.getRfcTraceWriter();
    private static final ThreadLocal<SimpleDateFormat> m_dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss,SSS", Locale.ENGLISH);
        }
    };
    private static final ThreadLocal<SimpleDateFormat> m_dateFormatShort = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss,SSS", Locale.ENGLISH);
        }
    };
    private static final String[] type_string = new String[]{"EXT", "R/3", "NEO", "PBK", "REG", "BGR"};
    public static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private static final String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHAR";
            }
            case 8: {
                return "INT";
            }
            case 6: {
                return "NUM";
            }
            case 2: {
                return "BCD";
            }
            case 1: {
                return "DATE";
            }
            case 3: {
                return "TIME";
            }
            case 7: {
                return "FLOAT";
            }
            case 23: {
                return "DECF16";
            }
            case 24: {
                return "DECF34";
            }
            case 4: {
                return "BYTE";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 99: {
                return "TABLE";
            }
            case 42: {
                return "XMLDATA";
            }
            case 29: {
                return "STRING";
            }
            case 30: {
                return "XSTRING";
            }
            case 40: {
                return "INT8";
            }
            case 9: {
                return "INT2";
            }
            case 10: {
                return "INT1";
            }
            case 54: {
                return "DTDAY";
            }
            case 55: {
                return "DTWEEK";
            }
            case 56: {
                return "DTMONTH";
            }
            case 57: {
                return "TSECOND";
            }
            case 58: {
                return "TMINUTE";
            }
            case 59: {
                return "CDAY";
            }
            case 51: {
                return "UTCLONG";
            }
            case 52: {
                return "UTCSECOND";
            }
            case 53: {
                return "UTCMINUTE";
            }
            case 31: {
                return "BOX";
            }
            case 32: {
                return "GENERIC_BOX";
            }
        }
        return "UNKNOWN";
    }

    public static String rfctype(int type) {
        if (type >= type_string.length) {
            return "???";
        }
        return type_string[type];
    }

    public static void rfc_hexdump(byte[] buffer, int blen) {
        byte[] localbuffer = new byte[16];
        int count = 0;
        int ptr = 0;
        if (buffer == null || blen == 0) {
            return;
        }
        while (blen != 0) {
            int i = 0;
            if (blen < 16) {
                System.arraycopy(buffer, ptr, localbuffer, 0, blen);
                Arrays.fill(localbuffer, blen, localbuffer.length, (byte)0);
                buffer = localbuffer;
                blen = 16;
            } else {
                System.arraycopy(buffer, ptr, localbuffer, 0, 16);
            }
            StringBuilder str = new StringBuilder(Integer.toHexString(count));
            for (i = str.length(); i < 6; ++i) {
                str.insert(0, '0');
            }
            str.append(" |");
            for (i = 0; i < 16; ++i) {
                if (i % 4 == 0) {
                    str.append(' ');
                }
                str.append(HEX[(byte)(localbuffer[i] >> 4 & 0xF)]);
                str.append(HEX[(byte)(localbuffer[i] & 0xF)]);
            }
            str.append(" |");
            for (i = 0; i < 16; ++i) {
                byte c = localbuffer[i];
                if (c > 31 && c < 127) {
                    str.append((char)c);
                    continue;
                }
                str.append('.');
            }
            str.append("\n");
            m_trc.debugTrace(str.toString());
            ptr += 16;
            blen -= 16;
            count += 16;
        }
    }

    public static void ab_rfctrc(String text) {
        m_trc.infoTrace(text);
    }

    public static void ab_rfctrc(String text, Throwable th) {
        if (th != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print(text);
            pw.write(JCoRuntime.CRLF);
            pw.write(9);
            th.printStackTrace(pw);
            pw.close();
            text = sw.toString();
        }
        m_trc.infoTrace(text);
    }

    private static void print_handle(long handle) {
        Trc.ab_rfctrc("\thandle = " + handle + JCoRuntime.CRLF);
    }

    public static void TRfcCall(long handle, String function, IRfcParameter[] importing_abap, IRfcParameter[] changing, IRfcTable[] tables) {
        if (function == null) {
            Trc.ab_rfctrc("*> RfcCall" + JCoRuntime.CRLF + "\tFUNCTION <null>" + JCoRuntime.CRLF);
        } else {
            Trc.ab_rfctrc("*> RfcCall" + JCoRuntime.CRLF + "\tFUNCTION " + function + JCoRuntime.CRLF);
        }
        Trc.print_handle(handle);
        Trc.print_parameters(importing_abap);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcReceive(long handle, IRfcParameter[] exporting_abap, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc("*> RfcReceive ..." + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        Trc.print_parameters(exporting_abap);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcAbort(long rfc_handle, String text) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + ">>>> RfcAbort called by external program ..." + JCoRuntime.CRLF);
        Trc.print_handle(rfc_handle);
        if (text == null) {
            text = "<null>";
        }
        Trc.ab_rfctrc("\ttext = " + text + JCoRuntime.CRLF + JCoRuntime.CRLF);
    }

    private static void print_parameters(IRfcParameter[] par) {
        if (par == null) {
            Trc.ab_rfctrc("\tparameter   = <null>" + JCoRuntime.CRLF + JCoRuntime.CRLF);
        } else {
            for (int i = 0; i < par.length; ++i) {
                Trc.ab_rfctrc("\tparameter[" + i + "].name = " + par[i].getName() + JCoRuntime.CRLF);
                Trc.ab_rfctrc("\tparameter[" + i + "].type = " + Trc.getTypeString(par[i].getType()) + JCoRuntime.CRLF);
                Trc.ab_rfctrc("\tparameter[" + i + "].length = " + par[i].getNumBytes() + JCoRuntime.CRLF + JCoRuntime.CRLF);
            }
        }
    }

    private static void print_tables(IRfcTable[] tables) {
        int i = 0;
        if (tables == null) {
            Trc.ab_rfctrc("\ttables = <null>" + JCoRuntime.CRLF + JCoRuntime.CRLF);
        } else {
            for (i = 0; i < tables.length; ++i) {
                Trc.ab_rfctrc("\ttable[" + i + "].name = " + tables[i].getName() + JCoRuntime.CRLF);
                int numRows = tables[i].getNumRows();
                if (numRows > 0) {
                    Trc.ab_rfctrc("\ttable[" + i + "].rows = " + numRows + JCoRuntime.CRLF);
                }
                Trc.ab_rfctrc("\ttable[" + i + "].length = " + tables[i].getRowLength() + JCoRuntime.CRLF + JCoRuntime.CRLF);
            }
        }
    }

    public static void TRfcGetName(long handle, String name) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + JCoRuntime.CRLF + "*> RfcGetName" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        if (name == null) {
            Trc.ab_rfctrc("\tfunctionname  = <null>" + JCoRuntime.CRLF);
        } else {
            Trc.ab_rfctrc("\tfunctionname  = " + name + JCoRuntime.CRLF);
        }
    }

    public static void TRfcGetData(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + "*> RfcGetData" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        Trc.print_parameters(importing);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    public static void TRfcSendData(long handle, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + "*> RfcSendData" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        Trc.print_parameters(exporting);
        Trc.print_parameters(changing);
        Trc.print_tables(tables);
    }

    static void TRfcRaise(long handle, String exception) {
        Trc.ab_rfctrc("*> RfcRaise" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        if (exception == null) {
            Trc.ab_rfctrc("\texception   = <null>" + JCoRuntime.CRLF);
        } else {
            Trc.ab_rfctrc("\texception   = " + exception + JCoRuntime.CRLF);
        }
    }

    static void TRfcRaiseErrorMessage(long handle, String exception, String messageClass, char messageType, String messageNumber, String[] messageParameters) {
        Trc.ab_rfctrc("*> RfcRaiseErrorMessage" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        Trc.ab_rfctrc("\texception     = " + exception + JCoRuntime.CRLF);
        Trc.ab_rfctrc("\tmessageClass  = " + messageClass + JCoRuntime.CRLF);
        Trc.ab_rfctrc("\tmessageType   = " + messageType + JCoRuntime.CRLF);
        Trc.ab_rfctrc("\tmessageNumber = " + messageNumber + JCoRuntime.CRLF);
        if (messageParameters != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sb.append('\'').append(messageParameters[i]).append("', ");
            }
            sb.append('\'').append(messageParameters[3]).append('\'');
            Trc.ab_rfctrc("\tmessageParameters = " + sb.toString() + JCoRuntime.CRLF);
        }
    }

    static void TRfcRaiseAbapClassException(long handle, AbapClassException ace) {
        Trc.ab_rfctrc("*> RaiseAbapClassException" + JCoRuntime.CRLF);
        Trc.print_handle(handle);
        Trc.ab_rfctrc("\tclass exception = " + ace.getClassName() + JCoRuntime.CRLF);
        Trc.ab_rfctrc("\tmessage = " + ace.getMessage() + JCoRuntime.CRLF);
    }

    public static void TRfcOpen(RfcOptions options) {
        Trc.TRfcApiStart(JCoRuntime.CRLF + JCoRuntime.CRLF + "*> RfcOpen" + JCoRuntime.CRLF + '\t' + options.toString());
    }

    public static void TRfcApiStart(String what) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + JCoRuntime.CRLF + "<* " + what + " >" + Trc.getTimeStamp() + "<" + JCoRuntime.CRLF + JCoRuntime.CRLF);
    }

    public static void TRfcApiEnd(String what, boolean happyEnd) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + JCoRuntime.CRLF + "<* " + what + " >" + Trc.getTimeStamp() + "<");
        if (happyEnd) {
            Trc.ab_rfctrc("\tsuccessful *>");
        } else {
            Trc.ab_rfctrc("\tfailed *>");
        }
        Trc.ab_rfctrc(JCoRuntime.CRLF + JCoRuntime.CRLF);
    }

    public static void tConString(boolean trace, String what) {
        if (trace) {
            m_trc.infoTrace(what);
        }
    }

    public static void tConStringHandle(boolean trace, String what, long handle) {
        if (trace) {
            StringBuilder text = new StringBuilder(64);
            text.append(what);
            text.append(" [");
            text.append(handle);
            text.append(']');
            m_trc.infoTrace(text.toString());
        }
    }

    public static void tConNativeBegin(boolean trace, String what, long handle) {
        if (trace) {
            Trc.tNativeBegin(what, handle);
        }
    }

    public static void tConNativeEnd(boolean trace, String what, long handle) {
        if (trace) {
            Trc.tNativeEnd(what, handle);
        }
    }

    private static void tNativeBegin(String what, long handle) {
        Trc.tTraceHandle("\t>> native call " + what, handle, null, null);
    }

    private static void tNativeEnd(String what, long handle) {
        Trc.tTraceHandle("\t<<  native call " + what, handle, null, null);
    }

    public static void TCpicNativeBegin(String what, long handle, String convid) {
        Trc.ab_rfctrc("\t>> CPIC native call ");
        Trc.tTraceHandle(what, handle, convid, null);
    }

    public static void TCpicNativeBegin(String what, long handle, byte[] convid) {
        Trc.ab_rfctrc("\t>> CPIC native call ");
        Trc.tTraceHandle(what, handle, Trc.convIDToString(convid), null);
    }

    public static void TCpicNativeEnd(String what, long handle, byte[] convid, String info) {
        Trc.ab_rfctrc("\t<< CPIC native call ");
        Trc.tTraceHandle(what, handle, Trc.convIDToString(convid), info);
    }

    public static void TCpicNativeEnd(String what, long handle, String convid, String info) {
        Trc.ab_rfctrc("\t<< CPIC native call ");
        Trc.tTraceHandle(what, handle, convid, info);
    }

    public static void TCpicNativeEnd(String what, long handle, byte[] convid, int rc) {
        Trc.TCpicNativeEnd(what, handle, convid, "rc: " + rc);
    }

    public static void TCpicNativeEnd(String what, long handle, String convid, int rc) {
        Trc.TCpicNativeEnd(what, handle, convid, "rc: " + rc);
    }

    public static void nativeBegin(String method) {
        Trc.ab_rfctrc(new StringBuilder(64).append(">> Begin native call ").append(method).append(JCoRuntime.CRLF).toString());
    }

    public static void nativeEnd(String method) {
        Trc.ab_rfctrc(new StringBuilder(64).append(">> End native call ").append(method).append(JCoRuntime.CRLF).toString());
    }

    private static void tTraceHandle(String what, long handle, String convid, String info) {
        StringBuilder text = new StringBuilder(100);
        text.append(what);
        text.append(" [");
        text.append(handle);
        text.append("] convid: ");
        text.append(convid);
        if (info != null) {
            text.append(' ');
            text.append(info);
        }
        text.append("  ");
        text.append(Trc.getTimeStampShort());
        text.append(JCoRuntime.CRLF);
        Trc.ab_rfctrc(text.toString());
    }

    public static void criticalTrace(long handle, String text) {
        Trc.criticalTrace(RfcIoControl.ab_rfccntl(handle), text);
    }

    public static synchronized void criticalTrace(String description, Exception ex) {
        StringBuilder text = new StringBuilder(256);
        text.append("Exception thrown [").append(Trc.getTimeStamp());
        text.append("]: ").append(description).append(JCoRuntime.CRLF);
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            pw.close();
            text.append(sw.toString()).append(JCoRuntime.CRLF);
        }
        m_trc.criticalTrace(text.toString());
    }

    public static synchronized void criticalTrace(String description, Error er) {
        StringBuilder text = new StringBuilder(256);
        text.append("Error thrown [").append(Trc.getTimeStamp());
        text.append("]: ").append(description).append(JCoRuntime.CRLF);
        if (er != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            er.printStackTrace(pw);
            pw.flush();
            pw.close();
            text.append(sw.toString()).append(JCoRuntime.CRLF);
        }
        m_trc.criticalTrace(text.toString());
    }

    private static synchronized void writeGeneralTrace(String traceType, RfcIoOpenCntl act_cntl, String text) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(traceType);
        sb.append(": ");
        if (act_cntl != null) {
            sb.append('[');
            sb.append(act_cntl.hrfc);
            sb.append(']');
        }
        sb.append(" >");
        sb.append(Trc.getTimeStamp());
        sb.append("<    ");
        sb.append(text);
        sb.append(JCoRuntime.CRLF);
        sb.append(JCoRuntime.CRLF);
        m_trc.criticalTrace(sb.toString());
    }

    public static synchronized void generalInfo(RfcIoOpenCntl act_cntl, String txt) {
        Trc.writeGeneralTrace("Info", act_cntl, txt);
    }

    public static synchronized void criticalTrace(RfcIoOpenCntl act_cntl, String txt) {
        Trc.writeGeneralTrace("Error", act_cntl, txt);
    }

    public static synchronized void closeTrace() {
        m_trc.closeTrace();
    }

    public static String getTimeStamp() {
        return m_dateFormat.get().format(new Date());
    }

    public static String getTimeStampShort() {
        return m_dateFormatShort.get().format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rfctrace(RfcIoOpenCntl act_cntl, String text, byte[] buffer, int blen) {
        String access_counter;
        if (act_cntl == null || !act_cntl.trace) {
            return;
        }
        StringBuilder tmp = new StringBuilder(256);
        Object object = act_cntl.access_counter_mutex;
        synchronized (object) {
            ++act_cntl.access_counter;
            access_counter = String.valueOf(act_cntl.access_counter);
        }
        tmp.append(">>>> [");
        tmp.append(act_cntl.hrfc);
        tmp.append("] ");
        tmp.append(act_cntl.name);
        tmp.append(' ');
        tmp.append(Trc.rfctype(act_cntl.type));
        tmp.append(" <ac: ");
        tmp.append(access_counter);
        tmp.append("> >>> ");
        tmp.append(text);
        tmp.append(" (");
        tmp.append(act_cntl.getCPICConversationID());
        tmp.append(')');
        tmp.append(JCoRuntime.CRLF);
        Trc.ab_rfctrc(tmp.toString());
        Trc.rfc_hexdump(buffer, blen);
    }

    public static void TRfcApiStart(RfcIoOpenCntl cntl, String where) {
        Trc.ab_rfctrc(JCoRuntime.CRLF + ">>> " + where + " [" + (cntl == null ? 0L : cntl.hrfc) + "] >" + Trc.getTimeStamp() + "< ..." + JCoRuntime.CRLF + JCoRuntime.CRLF);
    }

    public static String convIDToString(byte[] convid) {
        if (convid != null) {
            try {
                return convid[0] == 0 ? "<initial>" : new String(convid, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "<empty>";
    }
}

