/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.compress;

import com.sap.conn.rfc.exceptions.RfcIoException;

public abstract class NgRfcAbstractOutputStream {
    protected byte[] buffer;
    protected int position;

    public NgRfcAbstractOutputStream(int bufferSize) {
        this.buffer = new byte[bufferSize];
        this.position = 0;
    }

    public final void flush() throws RfcIoException {
        this.flush(false);
    }

    public final void close() throws RfcIoException {
        this.flush(true);
    }

    protected abstract void flush(boolean var1) throws RfcIoException;

    public final void compressAndWrite(byte b) throws RfcIoException {
        this.buffer[this.position] = b;
        ++this.position;
        if (this.position == this.buffer.length) {
            this.flush(false);
        }
    }

    public final void compressAndWrite(byte[] data, int offset, int length) throws RfcIoException {
        if (data == null || length == 0) {
            return;
        }
        if (this.position + length <= this.buffer.length) {
            System.arraycopy(data, offset, this.buffer, this.position, length);
            this.position += length;
            if (this.position == this.buffer.length) {
                this.flush(false);
            }
        } else {
            int bytesCanBeWrittenNow = this.buffer.length - this.position;
            System.arraycopy(data, offset, this.buffer, this.position, bytesCanBeWrittenNow);
            this.position += bytesCanBeWrittenNow;
            this.flush(false);
            this.compressAndWrite(data, offset + bytesCanBeWrittenNow, length - bytesCanBeWrittenNow);
        }
    }

    public final void compressAndWrite(byte ... data) throws RfcIoException {
        this.compressAndWrite(data, 0, data.length);
    }
}

