/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.compress;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcAbstractOutputStream;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.sendStream.NgRfcSendStream;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtilCompression;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.nio.ByteBuffer;

public final class NgRfcLZ4Compression
extends NgRfcAbstractOutputStream
implements NgRfcDataCompressionBase {
    private final NgRfcSendStream sendStream;
    private final byte[] lz4CompBuffer;
    private final byte[][] ringBuffer;
    private int bufferIndex;
    private ByteBuffer compressorPointer;

    public NgRfcLZ4Compression(RfcIoOpenCntl act_cntl, Converter converter) {
        super(0x100000);
        this.sendStream = new NgRfcSendStream(act_cntl, converter);
        this.lz4CompBuffer = new byte[NgRfcUtilCompression.LZ4_COMP_BUFFER_SIZE];
        this.ringBuffer = new byte[][]{this.buffer, new byte[0x100000]};
        this.bufferIndex = 0;
        this.compressorPointer = this.createCompressor(this.ringBuffer[0], this.ringBuffer[1], this.lz4CompBuffer);
        try {
            this.sendStream.compressAndWrite((byte)52);
        }
        catch (RfcIoException e) {
            throw new CbRfcException("IO Error at LZ4 compression", e);
        }
    }

    private native ByteBuffer createCompressor(byte[] var1, byte[] var2, byte[] var3);

    private native void deleteCompressor(ByteBuffer var1);

    private native int LZ4_compress_fast_continue(ByteBuffer var1, int var2);

    @Override
    protected void flush(boolean isLastPacket) throws RfcIoException {
        if (this.position == 0) {
            return;
        }
        int compLength = this.LZ4_compress_fast_continue(this.compressorPointer, this.position);
        if (compLength == -1) {
            throw new CbRfcException("Error at LZ4_compress_fast_continue");
        }
        this.sendStream.compressAndWrite(RfcUtilities.intAsByteArray(this.position));
        this.sendStream.compressAndWrite(RfcUtilities.intAsByteArray(compLength));
        this.sendStream.compressAndWrite(this.lz4CompBuffer, 0, compLength);
        this.position = 0;
        if (isLastPacket) {
            this.sendStream.close();
            this.deleteCompressor(this.compressorPointer);
        } else {
            this.bufferIndex = (this.bufferIndex + 1) % 2;
            this.buffer = this.ringBuffer[this.bufferIndex];
        }
    }

    @Override
    public void resetNumWrittenByteCounter() {
        this.sendStream.resetNumWrittenByteCounter();
    }

    @Override
    public int getCount() {
        return this.sendStream.getCount();
    }

    static {
        JCoRuntime.registerNatives(NgRfcLZ4Compression.class);
    }
}

