/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.compress;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcAbstractOutputStream;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.sendStream.NgRfcSendStream;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtilCompression;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.zip.Deflater;

public final class NgRfcZLibCompression
extends NgRfcAbstractOutputStream
implements NgRfcDataCompressionBase {
    private final NgRfcSendStream sendStream;
    private final Deflater deflater;

    public NgRfcZLibCompression(RfcIoOpenCntl act_cntl, Converter converter) {
        super(0x100000);
        this.sendStream = new NgRfcSendStream(act_cntl, converter);
        this.deflater = new Deflater((act_cntl.serializationFormat & NgRfcUtilCompression.NgRfcCompMask.NGRFC_COMP_FAST.getValue()) != 0 ? 1 : 9, true);
        try {
            this.sendStream.compressAndWrite((byte)71);
        }
        catch (RfcIoException e) {
            throw new CbRfcException("IO Error at ZLib compression", e);
        }
    }

    @Override
    protected void flush(boolean isLastPacket) throws RfcIoException {
        if (isLastPacket) {
            if (this.position == this.buffer.length) {
                this.flush(false);
            }
            this.buffer[this.position] = 87;
            ++this.position;
        } else if (this.position == 0) {
            return;
        }
        this.deflater.setInput(this.buffer, 0, this.position);
        if (isLastPacket) {
            this.deflater.finish();
        }
        this.position = 0;
        while (!this.deflater.needsInput() || isLastPacket && !this.deflater.finished()) {
            int length = this.deflater.deflate(this.sendStream.buffer, this.sendStream.position, this.sendStream.buffer.length - this.sendStream.position);
            this.sendStream.position += length;
            if (this.sendStream.position == this.sendStream.buffer.length) {
                if (isLastPacket && this.deflater.finished()) {
                    this.sendStream.close();
                    continue;
                }
                this.sendStream.flush();
                continue;
            }
            if (!isLastPacket) continue;
            this.sendStream.close();
        }
    }

    @Override
    public void resetNumWrittenByteCounter() {
        this.sendStream.resetNumWrittenByteCounter();
    }

    @Override
    public int getCount() {
        return this.sendStream.getCount();
    }
}

