/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.decompress;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcAbstractInputStream;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDataDecompressionBase;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.NgRfcReceiveStream;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtilCompression;
import java.nio.ByteBuffer;

public final class NGRFCLZ4Decompression
extends NgRfcAbstractInputStream
implements NgRfcDataDecompressionBase {
    private final boolean isBigEndian;
    private final NgRfcReceiveStream receiveStream;
    private final byte[] lz4CompBuffer;
    private final byte[][] ringBuffer;
    private ByteBuffer decompressorPointer;
    private int bufferIndex;

    public NGRFCLZ4Decompression(RfcIoOpenCntl act_cntl, int rfcid, int rfcleng) {
        super(0x100000);
        this.isBigEndian = act_cntl.intformat == 2;
        this.receiveStream = new NgRfcReceiveStream(act_cntl, rfcid, rfcleng);
        this.lz4CompBuffer = new byte[NgRfcUtilCompression.LZ4_COMP_BUFFER_SIZE];
        this.ringBuffer = new byte[][]{this.buffer, new byte[0x100000]};
        this.decompressorPointer = this.createDecompressor(this.ringBuffer[0], this.ringBuffer[1], this.lz4CompBuffer);
    }

    @Override
    public void initialize() {
        this.receiveStream.initialize();
        short compFlag = this.receiveStream.readByte();
        if (52 != compFlag) {
            throw new CbRfcException("NGRFC_LZ4-compression begin mark '52' missing, instead read " + compFlag);
        }
        this.bufferIndex = 1;
        this.getNextSegment();
    }

    @Override
    public void finish() {
        this.deleteDecompressor(this.decompressorPointer);
    }

    private native ByteBuffer createDecompressor(byte[] var1, byte[] var2, byte[] var3);

    private native void deleteDecompressor(ByteBuffer var1);

    private native int LZ4_decompress_fast_usingDict(ByteBuffer var1, int var2, int var3);

    @Override
    protected int getNextSegment() {
        int origLength = this.readInt();
        int compLength = this.readInt();
        this.receiveStream.readBytes(this.lz4CompBuffer, 0, compLength);
        int decompLength = this.LZ4_decompress_fast_usingDict(this.decompressorPointer, origLength, compLength);
        if (compLength != decompLength) {
            throw new CbRfcException("LZ4-decompress failed, compLength=" + compLength + " decompLength=" + decompLength);
        }
        this.bufferIndex = (this.bufferIndex + 1) % 2;
        this.buffer = this.ringBuffer[this.bufferIndex];
        this.position = 0;
        this.maxPosition = origLength;
        return origLength;
    }

    private int readInt() {
        byte[] tmpBuffer = new byte[4];
        this.receiveStream.readBytes(tmpBuffer, 0, tmpBuffer.length);
        return RfcUtilities.byteArrayToInt(tmpBuffer, 0, this.isBigEndian);
    }

    static {
        JCoRuntime.registerNatives(NGRFCLZ4Decompression.class);
    }
}

