/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.decompress;

import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcAbstractInputStream;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDataDecompressionBase;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.NgRfcReceiveStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class NGRFCZLibDecompression
extends NgRfcAbstractInputStream
implements NgRfcDataDecompressionBase {
    private final NgRfcReceiveStream receiveStream;
    private final Inflater inflater;

    public NGRFCZLibDecompression(RfcIoOpenCntl act_cntl, int rfcid, int rfcleng) {
        super(0x100000);
        this.receiveStream = new NgRfcReceiveStream(act_cntl, rfcid, rfcleng);
        this.inflater = new Inflater(true);
    }

    @Override
    public void initialize() {
        this.receiveStream.initialize();
        short compFlag = this.receiveStream.readByte();
        if (71 != compFlag) {
            throw new CbRfcException("ZLIB-compression begin mark '71' missing, instead read " + compFlag);
        }
        this.getNextSegment();
    }

    @Override
    protected int getNextSegment() {
        this.position = 0;
        this.fillBufferFromInflater();
        while (this.position < this.maxPosition) {
            if (this.receiveStream.position == this.receiveStream.maxPosition && this.receiveStream.getNextSegment() == 0) {
                int savePos = this.position;
                this.position = 0;
                return savePos;
            }
            this.inflater.setInput(this.receiveStream.buffer, this.receiveStream.position, this.receiveStream.maxPosition - this.receiveStream.position);
            this.receiveStream.position = this.receiveStream.maxPosition;
            this.fillBufferFromInflater();
        }
        int savePos = this.position;
        this.position = 0;
        return savePos;
    }

    private void fillBufferFromInflater() {
        while (this.position < this.maxPosition && !this.inflater.needsInput() && !this.inflater.finished()) {
            int length;
            try {
                length = this.inflater.inflate(this.buffer, this.position, this.maxPosition - this.position);
            }
            catch (DataFormatException e) {
                throw new CbRfcException("Data format for ZLIB is wrong", e);
            }
            this.position += length;
        }
    }

    @Override
    public void finish() {
    }
}

