/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.decompress;

public abstract class NgRfcAbstractInputStream {
    protected byte[] buffer;
    protected int position;
    protected int maxPosition;

    public NgRfcAbstractInputStream(int bufferSize) {
        this.buffer = new byte[bufferSize];
        this.position = 0;
        this.maxPosition = bufferSize;
    }

    public byte readByte() {
        if (this.position == this.maxPosition) {
            this.getNextSegment();
        }
        return this.buffer[this.position++];
    }

    public void readBytes(byte[] data, int offset, int length) {
        if (this.position + length <= this.maxPosition) {
            System.arraycopy(this.buffer, this.position, data, offset, length);
            this.position += length;
            if (this.position == this.maxPosition) {
                this.getNextSegment();
            }
        } else {
            int bytesCanBeReadNow = this.maxPosition - this.position;
            System.arraycopy(this.buffer, this.position, data, offset, bytesCanBeReadNow);
            this.getNextSegment();
            this.readBytes(data, offset + bytesCanBeReadNow, length - bytesCanBeReadNow);
        }
    }

    public void skipByte() {
        if (this.position == this.maxPosition) {
            this.getNextSegment();
        }
        ++this.position;
    }

    public void skipBytes(int length) {
        if (this.position + length <= this.maxPosition) {
            this.position += length;
            if (this.position == this.maxPosition) {
                this.getNextSegment();
            }
        } else {
            int bytesCanBeReadNow = this.maxPosition - this.position;
            this.getNextSegment();
            this.skipBytes(length - bytesCanBeReadNow);
        }
    }

    protected abstract int getNextSegment();
}

