/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.decompress;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.DecompressionFactory;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDataDecompressionBase;
import com.sap.conn.rfc.exceptions.RfcIoException;

public final class NgRfcDecompressionReader {
    private final RfcIoOpenCntl act_cntl;
    private final boolean isBigEndian;
    private NgRfcDataDecompressionBase decompressor;

    public NgRfcDecompressionReader(RfcIoOpenCntl act_cntl) {
        this.act_cntl = act_cntl;
        this.isBigEndian = act_cntl.intformat == 2;
    }

    public void initialize(int rfcid, int rfcleng) {
        if (rfcleng > 27994 || rfcleng < 14) {
            throw new CbRfcException("Wrong header field: rfcLength");
        }
        this.readHeader();
        this.decompressor = DecompressionFactory.createDecompressor(this.act_cntl, rfcid, rfcleng);
        this.decompressor.initialize();
    }

    private void readHeader() {
        byte[] header;
        block6: {
            header = new byte[14];
            try {
                this.act_cntl.ab_rfcread(header, 14, 0);
            }
            catch (RfcIoException ioEx) {
                if (!this.act_cntl.trace) break block6;
                Trc.criticalTrace("initial read of parameter not successful" + JCoRuntime.CRLF, ioEx);
            }
        }
        if (header[0] != 94 && header[0] != 36) {
            throw new CbRfcException("Wrong header field: NGRFC_SEGMENT_BEGIN or NGRFC_LAST_SEGMENT_BEGIN");
        }
        if (header[1] != 72) {
            throw new CbRfcException("Wrong header field: NGRFC_HEADER");
        }
        if (header[2] < 2) {
            throw new CbRfcException("Wrong header field: protocol_version " + header[2] + " is smaller as " + 2);
        }
        if (header[3] < 3) {
            throw new CbRfcException("Wrong header field: understand protocol_version " + header[3] + " is not bigger as " + 3);
        }
        this.act_cntl.serializationFormat = RfcUtilities.byteArrayToShort(header, 10, this.act_cntl.intformat == 2);
    }

    public short readShort() {
        byte[] tmpBuffer = new byte[2];
        this.readBytes(tmpBuffer, 0, tmpBuffer.length);
        return RfcUtilities.byteArrayToShort(tmpBuffer, 0, this.isBigEndian);
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt() {
        byte[] tmpBuffer = new byte[4];
        this.readBytes(tmpBuffer, 0, tmpBuffer.length);
        return RfcUtilities.byteArrayToInt(tmpBuffer, 0, this.isBigEndian);
    }

    public long readUnsignedInt() {
        return this.readInt() & 0xFFFFFFFF;
    }

    public long readLong() {
        byte[] tmpBuffer = new byte[8];
        this.readBytes(tmpBuffer, 0, tmpBuffer.length);
        return RfcUtilities.byteArrayToLong(tmpBuffer, 0, this.isBigEndian);
    }

    public byte readByte() {
        return this.decompressor.readByte();
    }

    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public void readBytes(byte[] data, int offset, int length) {
        this.decompressor.readBytes(data, offset, length);
    }

    public void skipByte() {
        this.decompressor.skipByte();
    }

    public void skipBytes(int length) {
        this.decompressor.skipBytes(length);
    }

    public byte[] readPacked(int lengthFromMetaData) {
        int offset;
        int numBytes;
        byte[] data = new byte[lengthFromMetaData];
        short firstByte = this.readUnsignedByte();
        if (firstByte == 16) {
            numBytes = 16;
            offset = lengthFromMetaData - numBytes;
        } else if ((firstByte & 0xF0) != 0) {
            numBytes = (byte)((firstByte & 0xF0) >> 4);
            offset = lengthFromMetaData - numBytes;
            data[offset] = (byte)(firstByte & 0xF);
            ++offset;
            numBytes = (short)(numBytes - 1);
        } else {
            numBytes = firstByte;
            offset = lengthFromMetaData - numBytes;
        }
        if (numBytes > lengthFromMetaData) {
            throw new CbRfcException("NgRfcReceiveStream: Buffer to small while reading packed data.");
        }
        this.readBytes(data, offset, numBytes);
        return data;
    }

    public void skipPacked() {
        short numBytes = this.readUnsignedByte();
        if ((numBytes & 0xF0) != 0) {
            numBytes = (byte)(((numBytes & 0xF0) >> 4) - 1);
        }
        this.skipBytes(numBytes);
    }

    public byte[] readBinaryCompressed(int lengthFromMetaData) {
        byte[] data = new byte[lengthFromMetaData];
        int numBytes = this.readUnsignedShort();
        if (numBytes > lengthFromMetaData) {
            throw new CbRfcException("NgRfcReceiveStream: Wrong buffer size for reading binary data: " + numBytes);
        }
        this.readBytes(data, 0, numBytes);
        return data;
    }

    public void skipBinaryCompressed() {
        int numBytes = this.readUnsignedShort();
        this.skipBytes(numBytes);
    }

    public void finish() {
        this.decompressor.finish();
    }
}

