/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.deserialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.ComplexStructureParameter;
import com.sap.conn.jco.rt.ComplexTableParameter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.FlatStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.NestedStructure;
import com.sap.conn.jco.rt.Parameter;
import com.sap.conn.jco.rt.SerializationAwareVisitor;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.api.SerializationAware;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.TableDeltaLogEntry;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerColumn;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerCompressionColumn;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerType;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcTypeReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.TableDeltaStates;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.NgRfcMetaData;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import java.util.ArrayList;
import java.util.HashMap;

public final class NgRfcDeserializer
implements SerializationAwareVisitor {
    private final RfcIoOpenCntl act_cntl;
    private TableDeltaLogEntry deltaLog;
    private final int sendCodepageType;
    private final HashMap<String, SerializationAware> parameters;
    private final HashMap<String, SerializationAware> parametersActivateOnly;
    private final NgRfcDecompressionReader decompressorReader;
    private final NgRfcTypeReader typeReader;
    private final NgRfcDeserializerType typeDeserialize;
    private final NgRfcDeserializerCompressionColumn valuesDeserialize;
    private final NgRfcDeserializerColumn columnDeserialize;
    private boolean supplyOut;
    private NgRfcMetaData metaData;

    public NgRfcDeserializer(RfcIoOpenCntl act_cntl, TableDeltaLogEntry deltaLog) {
        this.act_cntl = act_cntl;
        this.deltaLog = deltaLog;
        this.parameters = new HashMap();
        this.parametersActivateOnly = new HashMap();
        this.decompressorReader = new NgRfcDecompressionReader(act_cntl);
        Converter converter = new Converter(act_cntl);
        this.sendCodepageType = converter.getSendCodepageType();
        this.typeReader = new NgRfcTypeReader(act_cntl, converter, this.decompressorReader);
        this.typeDeserialize = new NgRfcDeserializerType(this.decompressorReader, this.typeReader);
        this.valuesDeserialize = new NgRfcDeserializerCompressionColumn(this.decompressorReader, this.typeReader);
        this.columnDeserialize = new NgRfcDeserializerColumn(this.sendCodepageType, this.decompressorReader, act_cntl, this.typeReader, this.typeDeserialize, this);
    }

    public void setParam(String name, SerializationAware param) {
        this.parameters.put(name, param);
    }

    public void setParamToActivateOnly(String name, SerializationAware param) {
        this.parametersActivateOnly.put(name, param);
    }

    public void ngRfcDeserializeParams(int rfcid, int rfcleng) {
        String paramName;
        this.decompressorReader.initialize(rfcid, rfcleng);
        this.supplyOut = false;
        this.metaData = new NgRfcMetaData(this.decompressorReader, this.act_cntl.trace, this.act_cntl.pcs > 1);
        while ((paramName = this.getParameterName()) != null) {
            SerializationAware param = null;
            if (this.parameters.containsKey(paramName)) {
                param = this.parameters.get(paramName);
                param.setActive();
            } else if (this.parametersActivateOnly.containsKey(paramName)) {
                this.parametersActivateOnly.get(paramName).setActive();
                assert (this.supplyOut);
                continue;
            }
            if (this.supplyOut) continue;
            if (this.deltaLog.objId != 0) {
                this.deserializeDeltaDelta();
                continue;
            }
            this.metaData.reset();
            this.metaData.readMetaData(false, TableDeltaStates.NO_DELTA);
            if (param != null) {
                param.accept(this);
                continue;
            }
            if (this.metaData.getType() == NgRfcType.NGRFC_TABLE) {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("skip table " + paramName + " with" + JCoRuntime.CRLF + this.metaData + JCoRuntime.CRLF);
                }
                this.skipTable(this.metaData, 0);
                continue;
            }
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("skip parameter " + paramName + " with" + JCoRuntime.CRLF + this.metaData + JCoRuntime.CRLF);
            }
            this.skipParameter(this.metaData, 0);
        }
        this.decompressorReader.finish();
    }

    private String getParameterName() {
        byte paramFlag = this.decompressorReader.readByte();
        this.supplyOut = paramFlag == 84 || paramFlag == 75;
        String param = null;
        switch (paramFlag) {
            case 66: 
            case 81: 
            case 84: {
                param = this.readName();
                if (!this.act_cntl.trace) break;
                Trc.ab_rfctrc(JCoRuntime.CRLF + "Read param " + param + " with flag: " + paramFlag + JCoRuntime.CRLF);
                break;
            }
            case 75: {
                param = this.readName();
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("RfcCall - Deserialize service call for " + param + JCoRuntime.CRLF);
                }
                int columnCount = this.decompressorReader.readUnsignedShort();
                for (int i = 0; i < columnCount; ++i) {
                    this.skipName();
                }
                break;
            }
            case 70: {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("RfcCall - Deserialize delta log for a line" + JCoRuntime.CRLF);
                }
                this.deserializeDeltaLog(TableDeltaStates.LINE_DELTA);
                return "";
            }
            case 65: {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("RfcCall - Deserialize delta log for a table" + JCoRuntime.CRLF);
                }
                this.deserializeDeltaLog(TableDeltaStates.TABLE_DELTA);
                return "";
            }
            case 69: {
                if (!this.act_cntl.trace) break;
                Trc.ab_rfctrc("RfcCall - Deserialization finished" + JCoRuntime.CRLF + JCoRuntime.CRLF);
                break;
            }
            default: {
                throw new CbRfcException("Read Wrong NgRfc IDs: " + paramFlag);
            }
        }
        return param;
    }

    private String readName() {
        short nameLength = this.decompressorReader.readUnsignedByte();
        byte[] data = new byte[nameLength];
        this.decompressorReader.readBytes(data, 0, nameLength);
        return new String(data, Utf8ByteToCharConverter.UTF_8);
    }

    private void skipName() {
        short nameLength = this.decompressorReader.readUnsignedByte();
        this.decompressorReader.skipBytes(nameLength);
    }

    private void deserializeDeltaLog(TableDeltaStates state) {
        this.deltaLog.operation = this.decompressorReader.readUnsignedByte();
        this.deltaLog.line = this.decompressorReader.readInt();
        this.metaData.reset();
        this.metaData.readMetaData(true, state);
        this.deltaLog.objId = this.metaData.getDeltaID();
        if (this.deltaLog.objId == 0) {
            throw new CbRfcException("Delta ID expected");
        }
    }

    private void deserializeDeltaDelta() {
        IRfcTable irfcTable;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("deserializeDeltaData with tableID " + this.deltaLog.objId + JCoRuntime.CRLF);
        }
        if ((irfcTable = this.act_cntl.getDmTable(this.deltaLog.objId)) == null) {
            throw new CbRfcException("table parameter with delta ID " + this.deltaLog.objId + " not found");
        }
        if (!(irfcTable instanceof TableParameter)) {
            throw new CbRfcException("DM table is not a table parameter!");
        }
        DefaultTable table = ((TableParameter)irfcTable).getTable();
        switch (this.deltaLog.operation) {
            case 10: {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("rebuild table" + JCoRuntime.CRLF);
                }
                this.deserializeTable(table, this.metaData);
                break;
            }
            case 5: {
                if (this.act_cntl.trace && table.getNumRows() >= this.deltaLog.line) {
                    Trc.ab_rfctrc("remove row " + (this.deltaLog.line - 1) + JCoRuntime.CRLF);
                }
                table.deleteRow(this.deltaLog.line - 1);
                break;
            }
            case 4: {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("append row" + JCoRuntime.CRLF);
                }
                table.appendRow();
                this.deserializeStructureFromTableRow(table, this.metaData);
                break;
            }
            case 6: {
                if (this.act_cntl.trace && table.getNumRows() >= this.deltaLog.line) {
                    Trc.ab_rfctrc("insert row " + (this.deltaLog.line - 1) + JCoRuntime.CRLF);
                }
                table.insertRow(this.deltaLog.line - 1);
                this.deserializeStructureFromTableRow(table, this.metaData);
                break;
            }
            case 7: 
            case 11: {
                if (table.getNumRows() < this.deltaLog.line) break;
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("update row " + (this.deltaLog.line - 1) + JCoRuntime.CRLF);
                }
                table.setRow(this.deltaLog.line - 1);
                this.deserializeStructureFromTableRow(table, this.metaData);
                break;
            }
            case 8: {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("clear table" + JCoRuntime.CRLF);
                }
                table.clear();
                break;
            }
            default: {
                if (!this.act_cntl.trace) break;
                Trc.ab_rfctrc("delta operation not handled " + this.deltaLog.operation + JCoRuntime.CRLF);
            }
        }
    }

    protected void skipParameter(NgRfcMetaData metaData, int offset) {
        block15: for (int i = offset; i < metaData.getColumnCount(); ++i) {
            byte compMode = this.decompressorReader.readByte();
            if (compMode == 73) continue;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("skipParameter " + i + " type " + (Object)((Object)metaData.getColumnType(i)) + JCoRuntime.CRLF);
            }
            switch (metaData.getColumnType(i)) {
                case NGRFC_INT1: {
                    this.decompressorReader.skipBytes(1);
                    continue block15;
                }
                case NGRFC_INT2: {
                    this.decompressorReader.skipBytes(2);
                    continue block15;
                }
                case NGRFC_INT4: {
                    this.decompressorReader.skipBytes(4);
                    continue block15;
                }
                case NGRFC_INT8: 
                case NGRFC_BIN_FLOAT64: {
                    this.decompressorReader.skipBytes(8);
                    continue block15;
                }
                case NGRFC_CHAR1: 
                case NGRFC_CHAR2: {
                    this.typeReader.skipChars(metaData.getColumnLength(i), compMode);
                    continue block15;
                }
                case NGRFC_DATE1: 
                case NGRFC_DATE2: {
                    this.typeDeserialize.skipDate(metaData.getColumnLength(i), compMode);
                    continue block15;
                }
                case NGRFC_TIME1: 
                case NGRFC_TIME2: {
                    this.typeDeserialize.skipTime(metaData.getColumnLength(i), compMode);
                    continue block15;
                }
                case NGRFC_NUM1: 
                case NGRFC_NUM2: {
                    this.typeReader.skipNumByte(metaData.getColumnLength(i), compMode);
                    continue block15;
                }
                case NGRFC_PBCD: {
                    this.typeReader.skipPacked(compMode);
                    continue block15;
                }
                case NGRFC_DEC_FLOAT64: 
                case NGRFC_DEC_FLOAT128: {
                    this.decompressorReader.skipBytes(metaData.getColumnLength(i));
                    continue block15;
                }
                case NGRFC_RAW: {
                    this.typeReader.skipRAW(compMode);
                    continue block15;
                }
                case NGRFC_STRING: {
                    this.typeReader.skipString();
                    continue block15;
                }
                case NGRFC_XSTRING: {
                    this.typeReader.skipXString();
                    continue block15;
                }
                default: {
                    throw new CbRfcException("Wrong type at skipParameter: " + (Object)((Object)metaData.getColumnType(i)));
                }
            }
        }
    }

    protected void skipTable(NgRfcMetaData metaData, int offset) {
        long rowCount;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Skip table from " + offset + " on" + JCoRuntime.CRLF);
        }
        if ((rowCount = metaData.getRowCount()) == 0L) {
            return;
        }
        for (int i = offset; i < metaData.getColumnCount(); ++i) {
            NgRfcType columnType = metaData.getColumnType(i);
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Skip column parameter type " + (Object)((Object)columnType) + JCoRuntime.CRLF);
            }
            byte compMode = 78;
            if (columnType != NgRfcType.NGRFC_TABLE) {
                compMode = this.decompressorReader.readByte();
            }
            if (compMode == 73) continue;
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Skip table column " + i + " is not initial" + JCoRuntime.CRLF);
            }
            if (compMode == 86) {
                this.valuesDeserialize.skipColumnWithValueCompression(metaData, i);
                continue;
            }
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Skip table column " + i + " without value compression with compMode " + compMode + JCoRuntime.CRLF);
            }
            this.columnDeserialize.skipColumn(metaData, rowCount, i, columnType, compMode);
        }
    }

    @Override
    public void visit(BgRfcUnit.UnitSerializer bgRfcParam) {
        NgRfcType type;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Deserializing UnitSerializer " + bgRfcParam.getName() + JCoRuntime.CRLF);
        }
        if ((type = this.metaData.getColumnType(0)) != NgRfcType.NGRFC_XSTRING) {
            throw new CbRfcException("Wrong type: UnitSerializer has to be defined as type XString, not as " + (Object)((Object)type));
        }
        byte compMode = this.decompressorReader.readByte();
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Read compMode: " + compMode + JCoRuntime.CRLF);
        }
        if (compMode == 73) {
            return;
        }
        bgRfcParam.setBytes(this.typeReader.readXString());
    }

    @Override
    public void visit(Parameter p) {
        String paramName = p.getName();
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Deserializing parameter " + paramName + JCoRuntime.CRLF);
        }
        DefaultParameterList record = p.getParameterList();
        int lengthFromReadMetaData = this.metaData.getColumnLength(0);
        NgRfcType type = this.metaData.getColumnType(0);
        byte compMode = this.decompressorReader.readByte();
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Read compMode: " + compMode + JCoRuntime.CRLF);
        }
        int fieldIndex = record.getMetaData().indexOfFieldInternal(paramName);
        this.deserializeField(record, fieldIndex, lengthFromReadMetaData, compMode, type);
    }

    private void deserializeField(AbstractRecord record, int fieldIndex, int lengthFromReadMetaData, byte compMode, NgRfcType type) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Deserialize field " + fieldIndex + " type " + (Object)((Object)type) + " read length " + lengthFromReadMetaData + " record length " + record.getMetaData().getLengths()[this.sendCodepageType][fieldIndex] + " compMode " + compMode + JCoRuntime.CRLF);
        }
        if (compMode == 73) {
            return;
        }
        switch (type) {
            case NGRFC_INT1: {
                record.encodeINT(this.decompressorReader.readUnsignedByte(), fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_INT2: {
                record.encodeINT(this.decompressorReader.readShort(), fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_INT4: {
                record.encodeINT(this.decompressorReader.readInt(), fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_INT8: {
                record.encodeLONG(this.decompressorReader.readLong(), fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: {
                this.typeDeserialize.deserializeChars(record, fieldIndex, lengthFromReadMetaData, record.getMetaData().getLengths()[this.sendCodepageType][fieldIndex], compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: {
                this.typeDeserialize.deserializeDate(record, fieldIndex, lengthFromReadMetaData, record.getMetaData().getLengths()[this.sendCodepageType][fieldIndex], compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                this.typeDeserialize.deserializeTime(record, fieldIndex, lengthFromReadMetaData, record.getMetaData().getLengths()[this.sendCodepageType][fieldIndex], compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_NUM1: 
            case NGRFC_NUM2: {
                this.typeDeserialize.deserializeNum(record, fieldIndex, lengthFromReadMetaData, compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_BIN_FLOAT64: {
                this.typeDeserialize.deserializeFloat(record, fieldIndex, lengthFromReadMetaData);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_PBCD: {
                this.typeDeserialize.deserializeBCD(record, fieldIndex, lengthFromReadMetaData, compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_DEC_FLOAT64: 
            case NGRFC_DEC_FLOAT128: {
                this.typeDeserialize.deserializeDecNumber(record, fieldIndex, lengthFromReadMetaData);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_RAW: {
                this.typeDeserialize.deserializeRAW(record, fieldIndex, lengthFromReadMetaData, compMode);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_STRING: {
                this.typeDeserialize.deserializeString(record, fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_XSTRING: {
                this.typeDeserialize.deserializeXString(record, fieldIndex);
                record.setInitialized(fieldIndex);
                break;
            }
            case NGRFC_TABLE: {
                NgRfcMetaData tableMeta = new NgRfcMetaData(this.decompressorReader, this.act_cntl.trace, this.act_cntl.pcs > 1);
                tableMeta.readMetaData(false, TableDeltaStates.NO_DELTA);
                if (tableMeta.getColumnCount() <= 0) break;
                this.deserializeTable(record.decodeTABLE(fieldIndex), tableMeta);
                record.setInitialized(fieldIndex);
                break;
            }
            default: {
                throw new CbRfcException("Wrong type at deserializeField " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void visit(ComplexStructureParameter csp) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Receiving complexStructureParameter: " + csp.getName() + JCoRuntime.CRLF);
        }
        this.deserializeNestedStructure((DefaultStructure)csp.getComplexParameter(), this.metaData, 0);
    }

    @Override
    public void visit(FlatStructure fs) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Receiving structure: " + fs.getName() + JCoRuntime.CRLF);
        }
        this.deserializeStructure(fs.getStructure(), this.metaData);
    }

    private void deserializeStructureFromTableRow(DefaultTable table, NgRfcMetaData metaData) {
        this.deserializeStructure(table, metaData);
    }

    protected void deserializeStructure(AbstractRecord structure, NgRfcMetaData metaData) {
        int localColumnCount = structure.getMetaData().getFieldCount();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            if (i >= localColumnCount) {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("Skip column parameter " + i + " type " + (Object)((Object)metaData.getColumnType(i)) + " length " + metaData.getColumnLength(i) + JCoRuntime.CRLF);
                }
                this.skipParameter(metaData, i);
                return;
            }
            byte compMode = this.decompressorReader.readByte();
            int lengthFromReadMetaData = metaData.getColumnLength(i);
            NgRfcType type = metaData.getColumnType(i);
            this.deserializeField(structure, i, lengthFromReadMetaData, compMode, type);
        }
    }

    @Override
    public void visit(NestedStructure ns) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Receiving nested structure: " + ns.getName() + JCoRuntime.CRLF);
        }
        this.deserializeNestedStructure(ns.getStructure(), this.metaData, 0);
    }

    private int deserializeNestedStructure(AbstractRecord structure, NgRfcMetaData metaData, int flatMetadataIndex) {
        int localColumnCount = structure.getMetaData().getFieldCount();
        for (int i = 0; i < localColumnCount; ++i) {
            byte localNgrfcType = structure.getMetaData().getTypes()[i];
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Deserialize nested structure type " + localNgrfcType + JCoRuntime.CRLF);
            }
            if (localNgrfcType == 17) {
                flatMetadataIndex = this.deserializeNestedStructure(structure.decodeSTRUCTURE(i), metaData, flatMetadataIndex);
                structure.setInitialized(i);
                continue;
            }
            byte compMode = localNgrfcType != 99 ? (byte)this.decompressorReader.readByte() : (byte)78;
            NgRfcType ngrfc_type = metaData.getColumnType(flatMetadataIndex);
            int lengthFromReadMetaData = metaData.getColumnLength(flatMetadataIndex);
            this.deserializeField(structure, i, lengthFromReadMetaData, compMode, ngrfc_type);
            ++flatMetadataIndex;
        }
        return flatMetadataIndex;
    }

    @Override
    public void visit(ComplexTableParameter ctp) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Receiving complexTableParameter: " + ctp.getName() + JCoRuntime.CRLF);
        }
        DefaultTable table = (DefaultTable)ctp.getComplexParameter();
        this.deserializeTable(table, this.metaData);
        table.setOnlyModifiedInNgrfc();
    }

    @Override
    public void visit(TableParameter tp) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Receiving table: " + tp.getName() + JCoRuntime.CRLF);
        }
        DefaultTable table = tp.getTable();
        this.deserializeTable(table, this.metaData);
        table.setOnlyModifiedInNgrfc();
    }

    protected void deserializeTable(DefaultTable table, NgRfcMetaData metaData) {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Deserialize table with" + JCoRuntime.CRLF + metaData + JCoRuntime.CRLF);
        }
        table.clear();
        long rowCount = metaData.getRowCount();
        if (rowCount == 0L) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("rowCount is 0, return" + JCoRuntime.CRLF);
            }
            return;
        }
        table.appendRows((int)rowCount);
        DefaultRecordMetaData localMetaData = table.getRecordMetaData();
        int localColumnCount = localMetaData.getDeepFieldsCount();
        ArrayList<Integer> indices = new ArrayList<Integer>(10);
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            if (i >= localColumnCount) {
                this.skipTable(metaData, i);
                return;
            }
            NgRfcType columnType = metaData.getColumnType(i);
            indices.clear();
            DefaultRecordMetaData currentStruct = NgRfcUtil.mapFlatToHierarchicalIndex(localMetaData, i, indices);
            int actualIndex = DefaultTable.getNestedTableFieldIndex(indices);
            int length = this.sendCodepageType == 1 ? currentStruct.getLengths()[1][actualIndex] : currentStruct.getLengths()[0][actualIndex];
            byte compMode = 78;
            if (columnType != NgRfcType.NGRFC_TABLE) {
                compMode = this.decompressorReader.readByte();
            }
            if (compMode == 73) {
                if (!this.act_cntl.trace) continue;
                Trc.ab_rfctrc("Deserialize column " + i + " type " + (Object)((Object)columnType) + " is initial" + JCoRuntime.CRLF);
                continue;
            }
            if (compMode == 86) {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("Deserialize column " + i + " type " + (Object)((Object)columnType) + " is compressed" + JCoRuntime.CRLF);
                }
                this.valuesDeserialize.deserializeColumnWithValueCompression(table, i, metaData, length, actualIndex, indices);
                continue;
            }
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Deserialize column " + i + " type " + (Object)((Object)columnType) + " compMode " + compMode + JCoRuntime.CRLF);
            }
            this.columnDeserialize.deserializeColumn(table, metaData, rowCount, indices, i, columnType, actualIndex, compMode);
        }
    }
}

