/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.deserialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializer;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcDeserializerType;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcTypeReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.TableDeltaStates;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.BitsReader;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.NgRfcMetaData;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcType;
import java.util.ArrayList;

public final class NgRfcDeserializerColumn {
    private final int sendCodepageType;
    private final NgRfcDecompressionReader decompressorReader;
    private final RfcIoOpenCntl act_cntl;
    private final NgRfcTypeReader typeReader;
    private final NgRfcDeserializerType typeDeserialize;
    private final NgRfcDeserializer deserializer;
    private DefaultTable table;
    private NgRfcMetaData metaData;
    private int rowCount;
    private ArrayList<Integer> indices;
    private int index;
    private int actualIndex;
    private byte compMode;

    public NgRfcDeserializerColumn(int sendCodepageType, NgRfcDecompressionReader decompressorReader, RfcIoOpenCntl act_cntl, NgRfcTypeReader typeReader, NgRfcDeserializerType typeDeserialize, NgRfcDeserializer ngRfcDeserializer) {
        this.sendCodepageType = sendCodepageType;
        this.decompressorReader = decompressorReader;
        this.act_cntl = act_cntl;
        this.typeReader = typeReader;
        this.typeDeserialize = typeDeserialize;
        this.deserializer = ngRfcDeserializer;
    }

    protected void deserializeColumn(DefaultTable table, NgRfcMetaData metaData, long rowCount, ArrayList<Integer> indices, int index, NgRfcType columnType, int actualIndex, byte compMode) {
        this.table = table;
        this.metaData = metaData;
        this.rowCount = (int)rowCount;
        this.indices = indices;
        this.index = index;
        this.actualIndex = actualIndex;
        this.compMode = compMode;
        switch (columnType) {
            case NGRFC_INT1: {
                if (compMode == 78) {
                    this.deserializeInt1ColumnWithoutCompression();
                    break;
                }
                this.deserializeInt1Column();
                break;
            }
            case NGRFC_INT2: {
                if (compMode == 78) {
                    this.deserializeInt2ColumnWithoutCompression();
                    break;
                }
                this.deserializeInt2Column();
                break;
            }
            case NGRFC_INT4: {
                if (compMode == 78) {
                    this.deserializeInt4ColumnWithoutCompression();
                    break;
                }
                this.deserializeInt4Column();
                break;
            }
            case NGRFC_INT8: {
                if (compMode == 78) {
                    this.deserializeInt8ColumnWithoutCompression();
                    break;
                }
                this.deserializeInt8Column();
                break;
            }
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: {
                this.deserializeCharColumn();
                break;
            }
            case NGRFC_NUM1: 
            case NGRFC_NUM2: {
                if (compMode == 79 || compMode == 67) {
                    this.deserializeCharColumn();
                    break;
                }
                this.deserializeNumColumn();
                break;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: {
                if (compMode == 74) {
                    this.deserializeDateColumn();
                    break;
                }
                this.deserializeCharColumn();
                break;
            }
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                if (compMode == 72) {
                    this.deserializeTimeColumn();
                    break;
                }
                this.deserializeCharColumn();
                break;
            }
            case NGRFC_BIN_FLOAT64: {
                this.deserializeFloatColumn();
                break;
            }
            case NGRFC_PBCD: {
                this.deserializePackedColumn();
                break;
            }
            case NGRFC_DEC_FLOAT64: 
            case NGRFC_DEC_FLOAT128: {
                this.deserializeDecFloatColumn();
                break;
            }
            case NGRFC_RAW: {
                this.deserializeRawColumn();
                break;
            }
            case NGRFC_STRING: {
                this.deserializeStringColumn();
                break;
            }
            case NGRFC_XSTRING: {
                this.deserializeXStringColumn();
                break;
            }
            case NGRFC_TABLE: {
                this.deserializeTableColumn();
                break;
            }
            default: {
                throw new CbRfcException("Wrong type at deserializeColumn: " + (Object)((Object)columnType));
            }
        }
    }

    protected void skipColumn(NgRfcMetaData metaData, long rowCount, int index, NgRfcType columnType, byte compMode) {
        this.metaData = metaData;
        this.rowCount = (int)rowCount;
        this.index = index;
        this.compMode = compMode;
        switch (columnType) {
            case NGRFC_INT1: {
                if (compMode == 78) {
                    this.skipInt1ValuesNoComp((int)rowCount);
                    break;
                }
                this.skipInt1Column();
                break;
            }
            case NGRFC_INT2: {
                if (compMode == 78) {
                    this.skipInt2ValuesNoComp((int)rowCount);
                    break;
                }
                this.skipInt2Column();
                break;
            }
            case NGRFC_INT4: {
                if (compMode == 78) {
                    this.skipInt4ValuesNoComp((int)rowCount);
                    break;
                }
                this.skipInt4Column();
                break;
            }
            case NGRFC_INT8: {
                if (compMode == 78) {
                    this.skipInt8ValuesNoComp((int)rowCount);
                    break;
                }
                this.skipInt8Column();
                break;
            }
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: {
                this.skipCharColumn();
                break;
            }
            case NGRFC_NUM1: 
            case NGRFC_NUM2: {
                if (compMode == 79 || compMode == 67) {
                    this.skipCharColumn();
                    break;
                }
                this.skipNumColumn();
                break;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: 
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                if (compMode == 74) {
                    this.skipDateColumn();
                    break;
                }
                if (compMode == 72) {
                    this.skipTimeColumn();
                    break;
                }
                this.skipCharColumn();
                break;
            }
            case NGRFC_BIN_FLOAT64: 
            case NGRFC_DEC_FLOAT64: 
            case NGRFC_DEC_FLOAT128: {
                this.skipDecFloatColumn();
                break;
            }
            case NGRFC_PBCD: {
                this.skipPackedColumn();
                break;
            }
            case NGRFC_RAW: {
                this.skipRawColumn();
                break;
            }
            case NGRFC_STRING: {
                this.skipStringColumn();
                break;
            }
            case NGRFC_XSTRING: {
                this.skipXStringColumn();
                break;
            }
            case NGRFC_TABLE: {
                this.skipTableColumn();
                this.metaData = metaData;
                this.rowCount = (int)rowCount;
                this.index = index;
                this.compMode = compMode;
                break;
            }
            default: {
                throw new CbRfcException("Wrong type at skipTable: " + (Object)((Object)columnType));
            }
        }
    }

    private void deserializeInt1ColumnWithoutCompression() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeINT(this.decompressorReader.readUnsignedByte(), this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeInt2ColumnWithoutCompression() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeINT(this.decompressorReader.readShort(), this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeInt4ColumnWithoutCompression() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeINT(this.decompressorReader.readInt(), this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeInt8ColumnWithoutCompression() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeLONG(this.decompressorReader.readLong(), this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeInt1Column() {
        long minValue = this.decompressorReader.readUnsignedByte();
        this.deserializeInts(minValue);
    }

    private void deserializeInt2Column() {
        long minValue = this.decompressorReader.readShort();
        this.deserializeInts(minValue);
    }

    private void deserializeInt4Column() {
        long minValue = this.decompressorReader.readInt();
        this.deserializeInts(minValue);
    }

    private void deserializeInts(long minValue) {
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            long ll = bitsReader.readLongLongBits(bitCount);
            actualRecord.encodeINT((int)(ll + minValue), this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeInt8Column() {
        long minValue = this.decompressorReader.readLong();
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            long ll = bitsReader.readLongLongBits(bitCount);
            actualRecord.encodeLONG(ll + minValue, this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void skipInt1ValuesNoComp(int rowCount) {
        this.decompressorReader.skipBytes(1 * rowCount);
    }

    private void skipInt2ValuesNoComp(int rowCount) {
        this.decompressorReader.skipBytes(2 * rowCount);
    }

    private void skipInt4ValuesNoComp(int rowCount) {
        this.decompressorReader.skipBytes(4 * rowCount);
    }

    private void skipInt8ValuesNoComp(int rowCount) {
        this.decompressorReader.skipBytes(8 * rowCount);
    }

    private void skipInt1Column() {
        this.decompressorReader.skipBytes(1);
        this.skipInts();
    }

    private void skipInt2Column() {
        this.decompressorReader.skipBytes(2);
        this.skipInts();
    }

    private void skipInt4Column() {
        this.decompressorReader.skipBytes(4);
        this.skipInts();
    }

    private void skipInt8Column() {
        this.decompressorReader.skipBytes(8);
        this.skipInts();
    }

    private void skipInts() {
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        bitsReader.skipLongLongBits(bitCount, this.rowCount);
    }

    private void deserializeNumColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeNum(actualRec, this.actualIndex, this.metaData.getColumnLength(this.index), this.compMode);
            this.setEdited(actualRec);
            ++i;
            this.table.nextRow();
        }
    }

    private void skipNumColumn() {
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            this.typeReader.skipNumByte(this.metaData.getColumnLength(this.index), this.compMode);
            ++i;
        }
    }

    private void deserializeDateColumn() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        char[][] values = this.typeReader.readDate(bitsReader, this.table.getNumRows());
        this.deserializeDateAndTimes(values);
    }

    private void deserializeTimeColumn() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        char[][] values = this.typeReader.readTime(bitsReader, this.table.getNumRows());
        this.deserializeDateAndTimes(values);
    }

    private void deserializeDateAndTimes(char[][] values) {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeCHARS(values[i], this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void skipDateColumn() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.typeReader.skipDate(bitsReader, this.rowCount);
    }

    private void skipTimeColumn() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.typeReader.skipTime(bitsReader, this.rowCount);
    }

    private void deserializeCharColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeChars(actualRecord, this.actualIndex, this.metaData.getColumnLength(this.index), actualRecord.getMetaData().getLengths()[this.sendCodepageType][this.actualIndex], this.compMode);
            this.setEdited(actualRecord);
            ++i;
            this.table.nextRow();
        }
    }

    private void deserializeFloatColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeFloat(actualRecord, this.actualIndex, this.metaData.getColumnLength(this.index));
            this.setEdited(actualRecord);
            ++i;
            this.table.nextRow();
        }
    }

    private void deserializePackedColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeBCD(actualRecord, this.actualIndex, this.metaData.getColumnLength(this.index), this.compMode);
            this.setEdited(actualRecord);
            ++i;
            this.table.nextRow();
        }
    }

    private void deserializeDecFloatColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeDecNumber(actualRecord, this.actualIndex, this.metaData.getColumnLength(this.index));
            this.setEdited(actualRecord);
            ++i;
            this.table.nextRow();
        }
    }

    private void deserializeRawColumn() {
        this.table.firstRow();
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeRAW(actualRecord, this.actualIndex, this.metaData.getColumnLength(this.index), this.compMode);
            this.setEdited(actualRecord);
            ++i;
            this.table.nextRow();
        }
    }

    private void deserializeStringColumn() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeString(actualRecord, this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeXStringColumn() {
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.typeDeserialize.deserializeXString(actualRecord, this.actualIndex);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void deserializeTableColumn() {
        this.table.firstRow();
        NgRfcMetaData subMeta = new NgRfcMetaData(this.decompressorReader, this.act_cntl.trace, this.act_cntl.pcs > 1);
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            this.setEdited(actualRecord);
            DefaultTable subTable = actualRecord.decodeTABLE(this.actualIndex);
            if (i == 0) {
                subMeta.readMetaData(false, TableDeltaStates.NO_DELTA);
            } else {
                subMeta.readColumnMetaData(false, TableDeltaStates.NO_DELTA);
            }
            int rowCount = this.rowCount;
            DefaultTable table = this.table;
            ArrayList<Integer> indices = this.indices;
            int actualIndex = this.actualIndex;
            this.deserializer.deserializeTable(subTable, subMeta);
            this.rowCount = rowCount;
            this.table = table;
            this.indices = indices;
            this.actualIndex = actualIndex;
            this.table.nextRow();
        }
    }

    private void skipCharColumn() {
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            this.typeReader.skipChars(this.metaData.getColumnLength(this.index), this.compMode);
            ++i;
        }
    }

    private void skipDecFloatColumn() {
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            this.decompressorReader.skipBytes(this.metaData.getColumnLength(this.index));
            ++i;
        }
    }

    private void skipPackedColumn() {
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            this.typeReader.skipPacked(this.compMode);
            ++i;
        }
    }

    private void skipRawColumn() {
        int i = 0;
        while ((long)i < this.metaData.getRowCount()) {
            this.typeReader.skipRAW(this.compMode);
            ++i;
        }
    }

    private void skipStringColumn() {
        for (int i = 0; i < this.rowCount; ++i) {
            this.typeReader.skipString();
        }
    }

    private void skipXStringColumn() {
        for (int i = 0; i < this.rowCount; ++i) {
            this.typeReader.skipXString();
        }
    }

    private void skipTableColumn() {
        NgRfcMetaData subMeta = new NgRfcMetaData(this.decompressorReader, this.act_cntl.trace, this.act_cntl.pcs > 1);
        for (int i = 0; i < this.rowCount; ++i) {
            if (i == 0) {
                subMeta.readMetaData(false, TableDeltaStates.NO_DELTA);
            } else {
                subMeta.readColumnMetaData(false, TableDeltaStates.NO_DELTA);
            }
            int rowCount = this.rowCount;
            this.deserializer.skipTable(subMeta, 0);
            this.rowCount = rowCount;
        }
    }

    private void setEdited(AbstractRecord record) {
        record.setInitialized(this.actualIndex);
        this.table.setModifiedWithoutOpcode();
        this.table.changeSameValueFlag(this.actualIndex, false);
    }
}

