/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.deserialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcTypeReader;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.BitsReader;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.NgRfcMetaData;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import java.util.ArrayList;

public final class NgRfcDeserializerCompressionColumn {
    private final NgRfcDecompressionReader decompressorReader;
    private final NgRfcTypeReader typeReader;
    private DefaultTable table;
    private NgRfcType columnType;
    private int lengthFromReadMetaData;
    private int lengthFromRecordMD;
    private int rowCount;
    private int index;
    private short valueCount;
    private byte compMode;
    private ArrayList<Integer> indices;

    public NgRfcDeserializerCompressionColumn(NgRfcDecompressionReader decompressorReader, NgRfcTypeReader typeReader) {
        this.decompressorReader = decompressorReader;
        this.typeReader = typeReader;
    }

    protected void deserializeColumnWithValueCompression(DefaultTable table, int index, NgRfcMetaData metaData, int lengthFromRecordMD, int actualIndex, ArrayList<Integer> indices) {
        this.table = table;
        this.rowCount = (int)metaData.getRowCount();
        this.columnType = metaData.getColumnType(index);
        this.lengthFromReadMetaData = metaData.getColumnLength(index);
        this.lengthFromRecordMD = lengthFromRecordMD;
        this.index = actualIndex;
        this.indices = indices;
        this.valueCount = this.decompressorReader.readUnsignedByte();
        if (this.valueCount == 1) {
            table.changeSameValueFlag(index, true);
        } else {
            table.changeSameValueFlag(index, false);
        }
        this.compMode = this.decompressorReader.readByte();
        switch (this.columnType) {
            case NGRFC_INT1: {
                assert (this.compMode != 78);
                this.deserializeInt1Values();
                break;
            }
            case NGRFC_INT2: {
                assert (this.compMode != 78);
                this.deserializeInt2Values();
                break;
            }
            case NGRFC_INT4: {
                assert (this.compMode != 78);
                this.deserializeInt4Values();
                break;
            }
            case NGRFC_INT8: {
                assert (this.compMode != 78);
                this.deserializeInt8Values();
                break;
            }
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: {
                this.deserializeCharValues();
                break;
            }
            case NGRFC_NUM1: 
            case NGRFC_NUM2: {
                this.deserializeNumValues();
                break;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: {
                if (this.compMode == 74) {
                    this.deserializeDateValues();
                    break;
                }
                this.deserializeCharValues();
                break;
            }
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                if (this.compMode == 72) {
                    this.deserializeTimeValues();
                    break;
                }
                this.deserializeCharValues();
                break;
            }
            case NGRFC_BIN_FLOAT64: {
                this.deserializeFloatValues();
                break;
            }
            case NGRFC_PBCD: {
                this.deserializePackedValues();
                break;
            }
            case NGRFC_RAW: {
                this.deserializeBinaryValues();
                break;
            }
            case NGRFC_DEC_FLOAT64: 
            case NGRFC_DEC_FLOAT128: {
                this.deserializeDecFloatValues();
                break;
            }
            case NGRFC_STRING: {
                this.deserializeStringValues();
                break;
            }
            case NGRFC_XSTRING: {
                this.deserializeXStringValues();
                break;
            }
            default: {
                throw new CbRfcException("Wrong type at deserializeColumnWithValueCompression");
            }
        }
    }

    protected void skipColumnWithValueCompression(NgRfcMetaData metaData, int index) {
        this.columnType = metaData.getColumnType(index);
        this.lengthFromReadMetaData = metaData.getColumnLength(index);
        this.rowCount = (int)metaData.getRowCount();
        this.valueCount = this.decompressorReader.readUnsignedByte();
        this.compMode = this.decompressorReader.readByte();
        switch (this.columnType) {
            case NGRFC_INT1: {
                assert (this.compMode != 78);
                this.decompressorReader.skipBytes(1);
                this.skipIntBits();
                break;
            }
            case NGRFC_INT2: {
                assert (this.compMode != 78);
                this.decompressorReader.skipBytes(2);
                this.skipIntBits();
                break;
            }
            case NGRFC_INT4: {
                assert (this.compMode != 78);
                this.decompressorReader.skipBytes(4);
                this.skipIntBits();
                break;
            }
            case NGRFC_INT8: {
                assert (this.compMode != 78);
                this.decompressorReader.skipBytes(8);
                this.skipIntBits();
                break;
            }
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: {
                int i;
                for (i = 0; i < this.valueCount; ++i) {
                    this.typeReader.skipChars(this.lengthFromReadMetaData, this.compMode);
                }
                break;
            }
            case NGRFC_NUM1: 
            case NGRFC_NUM2: {
                int i;
                if (this.compMode == 79 || this.compMode == 67) {
                    for (i = 0; i < this.valueCount; ++i) {
                        this.typeReader.skipChars(this.lengthFromReadMetaData, this.compMode);
                    }
                } else {
                    for (i = 0; i < this.valueCount; ++i) {
                        this.typeReader.skipNumByte(this.lengthFromReadMetaData, this.compMode);
                    }
                }
                break;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: {
                int i;
                if (this.compMode == 74) {
                    this.skipDateValues();
                    break;
                }
                for (i = 0; i < this.valueCount; ++i) {
                    this.typeReader.skipChars(this.lengthFromReadMetaData, this.compMode);
                }
                break;
            }
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                int i;
                if (this.compMode == 72) {
                    this.skipTimeValues();
                    break;
                }
                for (i = 0; i < this.valueCount; ++i) {
                    this.typeReader.skipChars(this.lengthFromReadMetaData, this.compMode);
                }
                break;
            }
            case NGRFC_PBCD: {
                this.skipPackedValues();
                break;
            }
            case NGRFC_RAW: {
                this.skipBinaryValues();
                break;
            }
            case NGRFC_BIN_FLOAT64: 
            case NGRFC_DEC_FLOAT64: 
            case NGRFC_DEC_FLOAT128: {
                this.skipFloatAndDecFloatValues();
                break;
            }
            case NGRFC_STRING: {
                this.skipStringValues();
                break;
            }
            case NGRFC_XSTRING: {
                this.skipXStringValues();
                break;
            }
            default: {
                throw new CbRfcException("Wrong type at skipColumnWithValueCompression: " + (Object)((Object)this.columnType));
            }
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        short bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        bitsReader.skipRawBits(bitCount, this.rowCount);
    }

    private void deserializeInt1Values() {
        short minValue = this.decompressorReader.readUnsignedByte();
        this.deserializeInts(minValue);
    }

    private void deserializeInt2Values() {
        short minValue = this.decompressorReader.readShort();
        this.deserializeInts(minValue);
    }

    private void deserializeInt4Values() {
        int minValue = this.decompressorReader.readInt();
        this.deserializeInts(minValue);
    }

    private void deserializeInts(int minValue) {
        int i;
        long[] values = new long[this.valueCount];
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        for (i = 0; i < this.valueCount; ++i) {
            values[i] = bitsReader.readLongLongBits(bitCount) + (long)minValue;
        }
        bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeINT((int)values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void deserializeInt8Values() {
        int i;
        long minValue = this.decompressorReader.readLong();
        long[] values = new long[this.valueCount];
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        for (i = 0; i < this.valueCount; ++i) {
            values[i] = bitsReader.readLongLongBits(bitCount) + minValue;
        }
        bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeLONG(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipIntBits() {
        short bitCount = this.decompressorReader.readUnsignedByte();
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        bitsReader.skipLongLongBits(bitCount, this.valueCount);
    }

    private void deserializeDateValues() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        char[][] values = this.typeReader.readDate(bitsReader, this.valueCount);
        this.deserializeBits(bitsReader, values);
    }

    private void deserializeTimeValues() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        char[][] values = this.typeReader.readTime(bitsReader, this.valueCount);
        this.deserializeBits(bitsReader, values);
    }

    private void deserializeBits(BitsReader bitsReader, char[][] values) {
        short bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            short pos = bitsReader.readRawBits(bitCount);
            AbstractRecord actualRecord = this.table.getNestedFieldRecord(this.indices, true);
            actualRecord.encodeCHARS(values[pos], this.index);
            this.setEdited(actualRecord);
            this.table.nextRow();
        }
    }

    private void skipDateValues() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.typeReader.skipDate(bitsReader, this.valueCount);
    }

    private void skipTimeValues() {
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        this.typeReader.skipTime(bitsReader, this.valueCount);
    }

    private void deserializeCharValues() {
        String[] values = new String[this.valueCount];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readChars(this.lengthFromReadMetaData, this.lengthFromRecordMD, this.compMode);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeCHAR(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void deserializeNumValues() {
        Object[] values = new Object[this.valueCount];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.compMode == 79 || this.compMode == 67 ? this.typeReader.readChars(this.lengthFromReadMetaData, this.lengthFromRecordMD, this.compMode) : (Object)this.typeReader.readNum(this.lengthFromReadMetaData, this.compMode);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            if (values[pos] instanceof String) {
                actualRec.encodeNUM((String)values[pos], this.index);
            } else {
                actualRec.encodeNUM((char[])values[pos], 0, ((char[])values[pos]).length, this.index);
            }
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void deserializeFloatValues() {
        char[][] values = new char[this.valueCount][];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readFloat(this.lengthFromReadMetaData);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeCHARS(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipFloatAndDecFloatValues() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.decompressorReader.skipBytes(this.lengthFromReadMetaData);
        }
    }

    private void deserializePackedValues() {
        byte[][] values = new byte[this.valueCount][];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readPacked(this.lengthFromReadMetaData, this.compMode);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            int lengthFromMetaData = values[pos].length;
            char[] charValues = new char[lengthFromMetaData];
            Converter.convertBytesToChars(values[pos], charValues, false);
            actualRec.encodeCHARS(charValues, 0, lengthFromMetaData, this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipPackedValues() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.typeReader.skipPacked(this.compMode);
        }
    }

    private void deserializeBinaryValues() {
        byte[][] values = new byte[this.valueCount][];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readRAW(this.lengthFromReadMetaData, this.compMode);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeBYTE(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipBinaryValues() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.typeReader.skipRAW(this.compMode);
        }
    }

    private void deserializeDecFloatValues() {
        char[][] values = new char[this.valueCount][];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readDecNumber(this.lengthFromReadMetaData);
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeCHARS(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void deserializeStringValues() {
        String[] values = new String[this.valueCount];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readString();
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeSTRING(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipStringValues() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.typeReader.skipString();
        }
    }

    private void deserializeXStringValues() {
        byte[][] values = new byte[this.valueCount][];
        for (int i = 0; i < this.valueCount; ++i) {
            values[i] = this.typeReader.readXString();
        }
        BitsReader bitsReader = new BitsReader(this.decompressorReader);
        byte bitCount = NgRfcUtil.getBitCountFromValues(this.valueCount);
        this.table.firstRow();
        for (int i = 0; i < this.rowCount; ++i) {
            AbstractRecord actualRec = this.table.getNestedFieldRecord(this.indices, true);
            short pos = bitsReader.readRawBits(bitCount);
            actualRec.encodeXSTRING(values[pos], this.index);
            this.setEdited(actualRec);
            this.table.nextRow();
        }
    }

    private void skipXStringValues() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.typeReader.skipXString();
        }
    }

    private void setEdited(AbstractRecord record) {
        record.setInitialized(this.index);
        this.table.setModifiedWithoutOpcode();
    }
}

