/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.deserialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.NgRfcTypeReader;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.BitsReader;

public final class NgRfcDeserializerType {
    private final NgRfcDecompressionReader decompressorReader;
    private final NgRfcTypeReader typeReader;

    protected NgRfcDeserializerType(NgRfcDecompressionReader decompressorReader, NgRfcTypeReader typeReader) {
        this.decompressorReader = decompressorReader;
        this.typeReader = typeReader;
    }

    protected void deserializeString(AbstractRecord record, int fieldIndex) {
        record.encodeSTRING(this.typeReader.readString(), fieldIndex);
    }

    protected void deserializeChars(AbstractRecord record, int fieldIndex, int lengthFromReadMetaData, int lengthFromRecordMD, short compMode) {
        record.encodeCHAR(this.typeReader.readChars(lengthFromReadMetaData, lengthFromRecordMD, compMode), fieldIndex);
    }

    protected void deserializeDate(AbstractRecord record, int fieldIndex, int lengthFromReadMetaData, int lengthFromRecordMD, short compMode) {
        switch (compMode) {
            case 67: 
            case 78: 
            case 79: {
                this.deserializeChars(record, fieldIndex, lengthFromReadMetaData, lengthFromRecordMD, compMode);
                break;
            }
            default: {
                assert (compMode == 77 || compMode == 71);
                this.deserializeNum(record, fieldIndex, lengthFromReadMetaData, compMode);
            }
        }
    }

    protected void skipDate(int lengthFromMetaData, short compMode) {
        switch (compMode) {
            case 67: 
            case 78: 
            case 79: {
                this.typeReader.skipChars(lengthFromMetaData, compMode);
                break;
            }
            default: {
                assert (compMode == 77 || compMode == 71);
                this.typeReader.skipNumByte(lengthFromMetaData, compMode);
            }
        }
    }

    protected void deserializeTime(AbstractRecord record, int fieldIndex, int lengthFromReadMetaData, int lengthFromRecordMD, short compMode) {
        switch (compMode) {
            case 67: 
            case 78: 
            case 79: {
                this.deserializeChars(record, fieldIndex, lengthFromReadMetaData, lengthFromRecordMD, compMode);
                break;
            }
            default: {
                BitsReader bitsReader = new BitsReader(this.decompressorReader);
                char[] value = this.typeReader.readTime(bitsReader, 1)[0];
                record.encodeCHARS(value, fieldIndex);
            }
        }
    }

    protected void skipTime(int lengthFromMetaData, short compMode) {
        switch (compMode) {
            case 67: 
            case 78: 
            case 79: {
                this.typeReader.skipChars(lengthFromMetaData, compMode);
                break;
            }
            default: {
                BitsReader bitsReader = new BitsReader(this.decompressorReader);
                this.typeReader.skipTime(bitsReader, 1);
            }
        }
    }

    protected void deserializeNum(AbstractRecord record, int fieldIndex, int lengthFromMetaData, short compMode) {
        char[] value = this.typeReader.readNum(lengthFromMetaData, compMode);
        record.encodeNUM(value, 0, value.length, fieldIndex);
    }

    protected void deserializeFloat(AbstractRecord record, int fieldIndex, int lengthFromMetaData) {
        record.encodeCHARS(this.typeReader.readFloat(lengthFromMetaData), fieldIndex);
    }

    protected void deserializeBCD(AbstractRecord record, int fieldIndex, int lengthFromMetaData, short compMode) {
        record.encodeBYTE(this.typeReader.readPacked(lengthFromMetaData, compMode), fieldIndex);
    }

    protected void deserializeRAW(AbstractRecord record, int fieldIndex, int lengthFromMetaData, short compMode) {
        record.encodeBYTE(this.typeReader.readRAW(lengthFromMetaData, compMode), fieldIndex);
    }

    protected void deserializeXString(AbstractRecord record, int fieldIndex) {
        record.encodeXSTRING(this.typeReader.readXString(), fieldIndex);
    }

    protected void deserializeDecNumber(AbstractRecord record, int fieldIndex, int lengthFromMetaData) {
        record.encodeCHARS(this.typeReader.readDecNumber(lengthFromMetaData), fieldIndex);
    }
}

