/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.deserialize;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.receiveStream.BitsReader;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;

public final class NgRfcTypeReader {
    private static final byte[] NUMBERS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 32, 95, 45, 58, 46, 43};
    private final RfcIoOpenCntl act_cntl;
    private final Converter converter;
    private final NgRfcDecompressionReader decompressorReader;

    protected NgRfcTypeReader(RfcIoOpenCntl act_cntl, Converter converter, NgRfcDecompressionReader decompressorReader) {
        this.act_cntl = act_cntl;
        this.converter = converter;
        this.decompressorReader = decompressorReader;
    }

    protected String readString() {
        int dataLength = this.decompressorReader.readUnsignedShort();
        if (dataLength == 0) {
            return null;
        }
        boolean sentInUtf8 = (dataLength & 0x8000) != 0;
        boolean lastBlock = (dataLength & 0x4000) != 0;
        long origLength = (dataLength &= 0x3FFF) / this.act_cntl.pcs;
        if ((sentInUtf8 || !lastBlock) && (origLength = (long)this.decompressorReader.readUnsignedShort()) == 65535L) {
            origLength = this.decompressorReader.readUnsignedInt();
        }
        byte[] tempBuffer = new byte[65535];
        StringBuilder sb = new StringBuilder((int)origLength);
        while (dataLength > 0) {
            int bytesToRead = Math.min(dataLength, 65535);
            this.decompressorReader.readBytes(tempBuffer, 0, bytesToRead);
            if (sentInUtf8) {
                sb.append(new String(tempBuffer, 0, bytesToRead, Utf8ByteToCharConverter.UTF_8));
            } else {
                sb.append(this.converter.encodeCharArr(tempBuffer, 0, bytesToRead));
            }
            if (lastBlock) {
                dataLength = 0;
                continue;
            }
            dataLength = this.decompressorReader.readUnsignedShort();
            lastBlock = (dataLength & 0x8000) != 0;
            if (!lastBlock) continue;
            dataLength ^= 0x8000;
        }
        return sb.toString();
    }

    protected void skipString() {
        int dataLength = this.decompressorReader.readUnsignedShort();
        if (dataLength == 0) {
            return;
        }
        boolean sentInUtf8 = (dataLength & 0x8000) != 0;
        boolean lastBlock = (dataLength & 0x4000) != 0;
        dataLength &= 0x3FFF;
        if ((sentInUtf8 || !lastBlock) && this.decompressorReader.readUnsignedShort() == 65535) {
            this.decompressorReader.skipBytes(4);
        }
        while (dataLength > 0) {
            int bytesToRead = Math.min(dataLength, 65535);
            this.decompressorReader.skipBytes(bytesToRead);
            if (lastBlock) {
                dataLength = 0;
                continue;
            }
            dataLength = this.decompressorReader.readUnsignedShort();
            lastBlock = (dataLength & 0x8000) != 0;
            if (!lastBlock) continue;
            dataLength ^= 0x8000;
        }
    }

    protected String readChars(int lengthFromReadMetaData, int lengthFromRecordMD, short compMode) {
        int lengthToRead = lengthFromReadMetaData;
        boolean sentInUTF8 = false;
        if (compMode == 67) {
            int dataLength = this.decompressorReader.readUnsignedShort();
            boolean bl = sentInUTF8 = (dataLength & 0x8000) != 0;
            if (sentInUTF8) {
                dataLength ^= 0x8000;
            }
            if (dataLength == 0) {
                return "";
            }
            lengthToRead = Math.min(lengthFromReadMetaData, dataLength);
        }
        if (!this.act_cntl.getCodepage().equals(this.act_cntl.getCommunicationCodepage())) {
            lengthToRead = Math.min(lengthToRead, lengthFromRecordMD);
        }
        byte[] tmpBuffer = new byte[lengthToRead];
        this.decompressorReader.readBytes(tmpBuffer, 0, lengthToRead);
        if (sentInUTF8) {
            return new String(tmpBuffer, Utf8ByteToCharConverter.UTF_8);
        }
        return this.converter.encodeString(tmpBuffer);
    }

    protected void skipChars(int lengthFromMetaData, short compMode) {
        int lengthToRead = lengthFromMetaData;
        boolean sentInUTF8 = false;
        if (compMode == 67) {
            int dataLength = this.decompressorReader.readUnsignedShort();
            boolean bl = sentInUTF8 = (dataLength & 0x8000) != 0;
            if (sentInUTF8) {
                dataLength ^= 0x8000;
            }
            if (dataLength == 0) {
                return;
            }
            lengthToRead = Math.min(lengthFromMetaData, dataLength);
        }
        this.decompressorReader.skipBytes(lengthToRead);
    }

    protected char[] readNum(int lengthFromMetaData, short compMode) {
        byte[] value = this.readNumByte(lengthFromMetaData, compMode);
        char[] temp_data = new char[lengthFromMetaData / this.act_cntl.pcs];
        Converter.convertBytesToChars(value, temp_data, true);
        return temp_data;
    }

    private byte[] readNumByte(int lengthFromMetaData, short compMode) {
        int numDigits = lengthFromMetaData;
        numDigits = compMode == 71 ? (int)this.decompressorReader.readUnsignedByte() : (numDigits /= this.act_cntl.pcs);
        int numBytesToRead = numDigits / 2 + numDigits % 2;
        byte[] nibbleBuffer = new byte[numBytesToRead];
        this.decompressorReader.readBytes(nibbleBuffer, 0, numBytesToRead);
        if (lengthFromMetaData < numDigits) {
            Trc.ab_rfctrc("Deserialization at encodeNum failed, length from meta data " + lengthFromMetaData + " is less than " + numDigits);
            return null;
        }
        byte[] valueBuffer = new byte[numDigits *= 2];
        int i = 0;
        for (int j = 1; i < numBytesToRead && j < numDigits; ++i, j += 2) {
            byte currentByte = nibbleBuffer[i];
            valueBuffer[j] = NUMBERS[(currentByte & 0xF0) >>> 4];
            if ((j += 2) >= numDigits) continue;
            valueBuffer[j] = NUMBERS[currentByte & 0xF];
        }
        return valueBuffer;
    }

    protected void skipNumByte(int lengthFromMetaData, short compMode) {
        lengthFromMetaData = compMode == 71 ? (int)this.decompressorReader.readUnsignedByte() : (lengthFromMetaData /= this.act_cntl.pcs);
        this.decompressorReader.skipBytes(lengthFromMetaData / 2 + lengthFromMetaData % 2);
    }

    protected char[] readFloat(int lengthFromMetaData) {
        byte[] data = new byte[lengthFromMetaData];
        this.decompressorReader.readBytes(data, 0, lengthFromMetaData);
        return this.converter.getEncodedNumber(data, lengthFromMetaData);
    }

    protected byte[] readXString() {
        int length = this.decompressorReader.readUnsignedShort();
        if (length == 65535) {
            length = (int)this.decompressorReader.readUnsignedInt();
        }
        byte[] data = new byte[length];
        this.decompressorReader.readBytes(data, 0, length);
        return data;
    }

    protected void skipXString() {
        int length = this.decompressorReader.readUnsignedShort();
        if (length == 65535) {
            length = (int)this.decompressorReader.readUnsignedInt();
        }
        this.decompressorReader.skipBytes(length);
    }

    protected char[] readDecNumber(int lengthFromMetaData) {
        byte[] data = new byte[lengthFromMetaData];
        this.decompressorReader.readBytes(data, 0, lengthFromMetaData);
        return this.converter.getEncodedDecNumber(data, lengthFromMetaData);
    }

    protected byte[] readRAW(int lengthFromMetaData, short compMode) {
        if (compMode != 76) {
            throw new CbRfcException("readRAW: wrong comp mode " + compMode);
        }
        return this.decompressorReader.readBinaryCompressed(lengthFromMetaData);
    }

    protected void skipRAW(short compMode) {
        if (compMode != 76) {
            throw new CbRfcException("skipRAW: wrong comp mode " + compMode);
        }
        this.decompressorReader.skipBinaryCompressed();
    }

    protected char[][] readDate(BitsReader bitsReader, int count) {
        char[][] values = new char[count][];
        int minValue = this.decompressorReader.readUnsignedShort();
        short bitCount = this.decompressorReader.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            values[i] = NgRfcUtil.convertBitsToDate(bitsReader.readLongLongBits(bitCount), minValue);
        }
        return values;
    }

    protected void skipDate(BitsReader bitsReader, int rowCount) {
        this.decompressorReader.skipBytes(2);
        short bitCount = this.decompressorReader.readUnsignedByte();
        bitsReader.skipLongLongBits(bitCount, rowCount);
    }

    protected char[][] readTime(BitsReader bitsReader, int count) {
        char[][] values = new char[count][];
        for (int i = 0; i < count; ++i) {
            values[i] = NgRfcUtil.convertBitsToTime(bitsReader.readLongLongBits((short)17));
        }
        return values;
    }

    protected void skipTime(BitsReader bitsReader, int rowCount) {
        bitsReader.skipLongLongBits((short)17, rowCount);
    }

    protected byte[] readPacked(int lengthFromMetaData, short compMode) {
        if (compMode != 66) {
            throw new CbRfcException("readPacked: wrong comp mode " + compMode);
        }
        return this.decompressorReader.readPacked(lengthFromMetaData);
    }

    protected void skipPacked(short compMode) {
        if (compMode != 66) {
            throw new CbRfcException("skipPacked: wrong comp mode " + compMode);
        }
        this.decompressorReader.skipPacked();
    }
}

