/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.receiveStream;

import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;

public final class BitsReader {
    private static final byte[] RAW_MASKS = new byte[]{0, 1, 3, 7, 15, 31, 63, 127};
    private static final long[] LL_MASKS = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE};
    private final NgRfcDecompressionReader decompressorReader;
    private short rawBits;
    private long llBits;
    private int rawBitsAvail;
    private int llBitsAvail;

    public BitsReader(NgRfcDecompressionReader decompressorReader) {
        this.decompressorReader = decompressorReader;
        this.rawBits = 0;
        this.llBits = 0L;
        this.rawBitsAvail = 0;
        this.llBitsAvail = 0;
    }

    public short readRawBits(short bitCount) {
        if (bitCount == 0) {
            return 0;
        }
        if (bitCount > 8) {
            throw new CbRfcException("Received value for bitCount is invalid. More than 8 bits in Byte.");
        }
        if (this.rawBitsAvail == 0) {
            this.rawBits = this.decompressorReader.readUnsignedByte();
            this.rawBitsAvail = 8;
        }
        short rawVal = 0;
        if (this.rawBitsAvail < bitCount) {
            rawVal = (short)(this.rawBits << bitCount - this.rawBitsAvail);
            this.rawBits = this.decompressorReader.readUnsignedByte();
            this.rawBitsAvail = 8 - (bitCount - this.rawBitsAvail);
            rawVal = (short)(rawVal | this.rawBits >>> this.rawBitsAvail);
        } else {
            rawVal = (short)(this.rawBits >>> this.rawBitsAvail - bitCount);
            this.rawBitsAvail -= bitCount;
        }
        this.rawBits = (short)(this.rawBits & RAW_MASKS[this.rawBitsAvail]);
        return rawVal;
    }

    public void skipRawBits(short bitCount, int rowCount) {
        if (bitCount == 0) {
            return;
        }
        int bytesToSkip = bitCount * rowCount / 8;
        if (bitCount * rowCount % 8 > 0) {
            ++bytesToSkip;
        }
        this.decompressorReader.skipBytes(bytesToSkip);
    }

    public long readLongLongBits(short bitCount) {
        if (bitCount == 0) {
            return 0L;
        }
        if (bitCount > 64) {
            throw new CbRfcException("Received value for bitCount is invalid. More than 64 bits in Long.");
        }
        if (this.llBitsAvail == 0) {
            this.llBits = this.decompressorReader.readLong();
            this.llBitsAvail = 64;
        }
        long ll = 0L;
        if (this.llBitsAvail < bitCount) {
            ll = this.llBits << bitCount - this.llBitsAvail;
            this.llBits = this.decompressorReader.readLong();
            this.llBitsAvail = 64 - (bitCount - this.llBitsAvail);
            ll |= this.llBits >>> this.llBitsAvail;
        } else {
            ll = this.llBits >>> this.llBitsAvail - bitCount;
            this.llBitsAvail -= bitCount;
        }
        this.llBits &= LL_MASKS[this.llBitsAvail];
        return ll;
    }

    public void skipLongLongBits(short bitCount, int rowCount) {
        if (bitCount == 0) {
            return;
        }
        int eightBytesToSkip = bitCount * rowCount / 64;
        if (bitCount * rowCount % 64 > 0) {
            ++eightBytesToSkip;
        }
        this.decompressorReader.skipBytes(eightBytesToSkip * 8);
    }
}

