/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.receiveStream;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcDecompressionReader;
import com.sap.conn.rfc.engine.ngrfc.deserialize.TableDeltaStates;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcType;

public final class NgRfcMetaData {
    private final NgRfcDecompressionReader decompressorReader;
    private final boolean trace;
    private final boolean partnerIsUnicode;
    private NgRfcColumnMetaData[] columnsData;
    private int pos;
    private NgRfcType type;
    private int deltaID;
    private long rowCount;

    public NgRfcMetaData(NgRfcDecompressionReader decompressorReader, boolean trace, boolean partnerIsUnicode) {
        this.decompressorReader = decompressorReader;
        this.trace = trace;
        this.partnerIsUnicode = partnerIsUnicode;
    }

    public void readMetaData(boolean useDelta, TableDeltaStates state) {
        byte compMode = this.decompressorReader.readByte();
        if (compMode == 73) {
            this.resize(0);
            if (this.trace) {
                Trc.ab_rfctrc("MetaData: read comp mode is initial" + JCoRuntime.CRLF);
            }
            return;
        }
        if (this.trace) {
            Trc.ab_rfctrc("MetaData: read comp mode " + compMode + JCoRuntime.CRLF);
        }
        this.readColumnMetaData(useDelta, state);
    }

    public void readColumnMetaData(boolean useDelta, TableDeltaStates state) {
        boolean mdAlreadySent;
        int tableFlag = this.decompressorReader.readUnsignedShort();
        boolean bl = mdAlreadySent = (tableFlag & 0x2000) != 0;
        if (this.trace) {
            Trc.ab_rfctrc("MetaData: read table flag 0x" + Integer.toHexString(tableFlag) + (mdAlreadySent ? ", MetaData has been already sent" : "") + JCoRuntime.CRLF);
        }
        if (!mdAlreadySent) {
            if ((tableFlag & 0x8000) != 0) {
                tableFlag ^= 0x8000;
                this.type = NgRfcType.NGRFC_TABLE;
                if (this.trace) {
                    Trc.ab_rfctrc("MetaData: column count " + tableFlag + JCoRuntime.CRLF);
                }
            } else if (tableFlag > 1) {
                this.type = NgRfcType.NGRFC_STRUCTURE;
            }
            this.resize(tableFlag);
        }
        if (useDelta || this.type == NgRfcType.NGRFC_TABLE) {
            this.deltaID = this.decompressorReader.readUnsignedShort();
            if (this.trace) {
                Trc.ab_rfctrc("MetaData: deltaID " + this.deltaID + JCoRuntime.CRLF);
            }
        }
        if (!mdAlreadySent) {
            for (int i = 0; i < tableFlag; ++i) {
                NgRfcType type = NgRfcType.getTypeForValue(this.decompressorReader.readByte());
                if (type == null) {
                    throw new CbRfcException("Wrong NgRfc type read at readMetaData");
                }
                int length = this.readTypeLength(type);
                if (this.trace) {
                    Trc.ab_rfctrc("MetaData: column " + i + " - length " + length + " type " + (Object)((Object)type) + JCoRuntime.CRLF);
                }
                this.addColumnMetaData(type, length);
            }
        }
        if (this.trace) {
            Trc.ab_rfctrc("MetaData: entry type " + (Object)((Object)this.type) + JCoRuntime.CRLF);
        }
        if (this.type == NgRfcType.NGRFC_TABLE && state != TableDeltaStates.LINE_DELTA) {
            if (this.columnsData != null && this.columnsData.length > 0) {
                this.rowCount = this.decompressorReader.readUnsignedShort();
                if (this.rowCount == 65535L) {
                    this.rowCount = this.decompressorReader.readLong();
                }
            } else {
                this.rowCount = 0L;
            }
            if (this.trace) {
                Trc.ab_rfctrc("MetaData: row count " + this.rowCount + JCoRuntime.CRLF);
            }
        }
    }

    private void resize(int columnCount) {
        if (columnCount != 0 && (this.columnsData == null || columnCount > this.columnsData.length)) {
            this.columnsData = new NgRfcColumnMetaData[columnCount];
        }
        this.pos = 0;
        this.deltaID = 0;
        this.rowCount = 0L;
    }

    private int readTypeLength(NgRfcType type) {
        int length = NgRfcType.typeNeedsLength(type) ? this.decompressorReader.readUnsignedShort() : (int)NgRfcType.getLengthOfNgRfcType(type, this.partnerIsUnicode);
        if (type == NgRfcType.NGRFC_PBCD) {
            this.decompressorReader.skipByte();
        }
        return length;
    }

    public NgRfcType getType() {
        return this.type;
    }

    public NgRfcType getColumnType(int columnIndex) {
        return this.columnsData[columnIndex].type;
    }

    public int getColumnLength(int columnIndex) {
        return this.columnsData[columnIndex].length;
    }

    public int getDeltaID() {
        return this.deltaID;
    }

    public void setDeltaID(int deltaID) {
        this.deltaID = deltaID;
    }

    public void addColumnMetaData(NgRfcType type, int length) {
        this.columnsData[this.pos] = new NgRfcColumnMetaData(length, type);
        ++this.pos;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public int getColumnCount() {
        return this.columnsData == null ? 0 : this.columnsData.length;
    }

    public void reset() {
        this.columnsData = null;
        this.pos = 0;
        this.type = null;
        this.deltaID = 0;
        this.rowCount = 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NgRfcMetaData.class.getSimpleName() + " with" + JCoRuntime.CRLF + "\ttype: " + (Object)((Object)this.type) + JCoRuntime.CRLF + "\tcolumnCount: " + this.getColumnCount() + JCoRuntime.CRLF + "\tdeltaID: " + this.deltaID + JCoRuntime.CRLF + "\trowCount: " + this.rowCount + JCoRuntime.CRLF);
        if (!(this.type != NgRfcType.NGRFC_TABLE && this.type != NgRfcType.NGRFC_STRUCTURE || this.isEmpty())) {
            sb.append("\t" + NgRfcColumnMetaData.class.getSimpleName() + ":" + JCoRuntime.CRLF);
            for (NgRfcColumnMetaData cmd : this.columnsData) {
                sb.append("\t" + cmd + JCoRuntime.CRLF);
            }
        }
        return sb.toString();
    }

    private boolean isEmpty() {
        if (this.columnsData == null || this.columnsData.length == 0) {
            return true;
        }
        for (int i = 0; i < this.columnsData.length; ++i) {
            if (this.columnsData[i] == null) continue;
            return false;
        }
        return true;
    }

    private final class NgRfcColumnMetaData {
        private final int length;
        private final NgRfcType type;

        private NgRfcColumnMetaData(int length, NgRfcType type) {
            this.length = length;
            this.type = type;
        }

        public String toString() {
            return "Type: " + (Object)((Object)this.type) + " Length: " + this.length;
        }
    }
}

