/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.receiveStream;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.decompress.NgRfcAbstractInputStream;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;

public final class NgRfcReceiveStream
extends NgRfcAbstractInputStream {
    private final RfcIoOpenCntl act_cntl;
    private int rfcLength;
    private int rfcID;

    public NgRfcReceiveStream(RfcIoOpenCntl act_cntl, int rfcid, int rfcleng) {
        super(27994);
        this.act_cntl = act_cntl;
        this.rfcLength = rfcleng;
        this.rfcID = rfcid;
    }

    public void initialize() {
        block5: {
            block4: {
                try {
                    this.act_cntl.ab_rfcread(this.buffer, this.rfcLength - 14, 14);
                }
                catch (RfcIoException ioEx) {
                    if (!this.act_cntl.trace) break block4;
                    Trc.criticalTrace("initial read of parameter not successful" + JCoRuntime.CRLF, ioEx);
                }
            }
            this.position = 14;
            try {
                this.act_cntl.readEndCheck(this.rfcID);
            }
            catch (RfcGetException e) {
                if (!this.act_cntl.trace) break block5;
                Trc.criticalTrace("Read wrong rfcID" + JCoRuntime.CRLF, e);
            }
        }
    }

    @Override
    public int getNextSegment() {
        block7: {
            if (this.rfcID == 20481) {
                return 0;
            }
            try {
                this.rfcID = this.act_cntl.readRFCID();
                if (this.rfcID != 20480 && this.rfcID != 20481) {
                    throw new CbRfcException("Invalid NgRfc data block received from RFC.");
                }
                this.rfcLength = this.act_cntl.readRFCLength();
                this.position = 0;
                this.act_cntl.ab_rfcread(this.buffer, this.rfcLength, this.position);
                this.act_cntl.readEndCheck(this.rfcID);
            }
            catch (RfcIoException e) {
                if (this.act_cntl.trace) {
                    Trc.ab_rfctrc("RfcCall - getNextNgRfcSegment() not successful" + JCoRuntime.CRLF, e);
                }
            }
            catch (RfcGetException e) {
                if (!this.act_cntl.trace) break block7;
                Trc.ab_rfctrc("RfcCall - getNextNgRfcSegment() not successful" + JCoRuntime.CRLF, e);
            }
        }
        if (this.buffer[this.position] != 94 && this.buffer[this.position] != 36) {
            throw new CbRfcException("Wrong field within stream: NGRFC_SEGMENT_BEGIN or NGRFC_LAST_SEGMENT_BEGIN");
        }
        ++this.position;
        return this.rfcLength;
    }
}

