/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.sendStream;

import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.exceptions.RfcIoException;

public final class BitsWriter {
    private final NgRfcDataCompressionBase compressor;
    private short rawBits;
    private long llBits;
    private byte llBitsAvail;
    private byte rawBitsAvail;

    public BitsWriter(NgRfcDataCompressionBase compressor) {
        this.compressor = compressor;
        this.rawBits = 0;
        this.llBits = 0L;
        this.rawBitsAvail = (byte)8;
        this.llBitsAvail = (byte)64;
    }

    public void writeRawBits(short data, short bitCount) throws RfcIoException {
        if (bitCount > 8) {
            throw new CbRfcException("Written value for bitCount is invalid. More than 8 bits in Byte.");
        }
        if (bitCount >= this.rawBitsAvail) {
            bitCount = (short)(bitCount - this.rawBitsAvail);
            this.rawBits = (short)(this.rawBits | data >>> bitCount);
            this.rawBitsAvail = 0;
            this.flushRawBits();
        }
        if (bitCount > 0) {
            this.rawBitsAvail = (byte)(this.rawBitsAvail - bitCount);
            this.rawBits = (short)(this.rawBits | data << this.rawBitsAvail);
        }
    }

    public void writeLongBits(long data, short bitCount) throws RfcIoException {
        if (bitCount > 64) {
            throw new CbRfcException("Written value for bitCount is invalid. More than 64 bits in Long.");
        }
        if (bitCount >= this.llBitsAvail) {
            bitCount = (short)(bitCount - this.llBitsAvail);
            this.llBits |= data >>> bitCount;
            this.llBitsAvail = 0;
            this.flushLLBits();
        }
        if (bitCount > 0) {
            this.llBitsAvail = (byte)(this.llBitsAvail - bitCount);
            this.llBits |= data << this.llBitsAvail;
        }
    }

    public void flushRawBits() throws RfcIoException {
        if (this.rawBitsAvail < 8) {
            this.compressor.compressAndWrite((byte)this.rawBits);
        }
        this.rawBits = 0;
        this.rawBitsAvail = (byte)8;
    }

    public void flushLLBits() throws RfcIoException {
        if (this.llBitsAvail < 64) {
            this.compressor.compressAndWrite(RfcUtilities.longAsByteArray(this.llBits));
        }
        this.llBits = 0L;
        this.llBitsAvail = (byte)64;
    }
}

