/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.sendStream;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPut;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcAbstractOutputStream;
import com.sap.conn.rfc.exceptions.RfcIoException;

public final class NgRfcSendStream
extends NgRfcAbstractOutputStream {
    private final RfcIoOpenCntl act_cntl;
    private final Converter converter;
    private int countWrittenBytes;

    public NgRfcSendStream(RfcIoOpenCntl act_cntl, Converter converter) {
        super(27994);
        this.act_cntl = act_cntl;
        this.converter = converter;
        this.countWrittenBytes = 0;
        this.setHeader();
    }

    private void setHeader() {
        this.buffer[0] = 94;
        this.buffer[1] = 72;
        this.buffer[2] = 3;
        this.buffer[3] = 3;
        this.buffer[4] = 1;
        byte[] charset = this.convertCharsetToByte(this.act_cntl.pcs == 1 ? this.act_cntl.getCommunicationCodepage() : this.act_cntl.getCodepage());
        this.buffer[5] = charset[0];
        this.buffer[6] = charset[1];
        this.buffer[7] = -16;
        this.buffer[8] = 0;
        this.buffer[9] = 0;
        byte[] serialFormat = RfcUtilities.shortAsByteArray(this.act_cntl.serializationFormat);
        this.buffer[10] = serialFormat[0];
        this.buffer[11] = serialFormat[1];
        this.buffer[12] = 0;
        this.buffer[13] = 0;
        this.position = 14;
    }

    private byte[] convertCharsetToByte(String charset) {
        byte[] charsetData = this.converter.decodeString(charset);
        int length = charsetData.length;
        byte[] tmpCharset = new byte[]{(byte)(charsetData[length / 8 + 0 * length / 4] - 48 << 4 | charsetData[length / 8 + 1 * length / 4] - 48), (byte)(charsetData[length / 8 + 2 * length / 4] - 48 << 4 | charsetData[length / 8 + 3 * length / 4] - 48)};
        return tmpCharset;
    }

    @Override
    protected void flush(boolean isLastPacket) throws RfcIoException {
        int rfcid = 20480;
        if (isLastPacket) {
            this.buffer[0] = 36;
            rfcid = 20481;
        }
        RfcPut.ab_rfcput(this.act_cntl, rfcid, this.buffer, this.position, 0);
        this.countWrittenBytes += this.position;
        this.buffer[0] = 94;
        this.position = 1;
    }

    public int getCount() {
        return this.countWrittenBytes;
    }

    public void resetNumWrittenByteCounter() {
        this.countWrittenBytes = 0;
    }
}

