/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.ComplexStructureParameter;
import com.sap.conn.jco.rt.ComplexTableParameter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.FlatStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.MiddlewareJavaRfc;
import com.sap.conn.jco.rt.NestedStructure;
import com.sap.conn.jco.rt.Parameter;
import com.sap.conn.jco.rt.RecordMetaDataInternal;
import com.sap.conn.jco.rt.SerializationAwareVisitor;
import com.sap.conn.jco.rt.TableParameter;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.compress.CompressionFactory;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerColumn;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerCompressionColumn;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerSimpleColumn;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtilCompression;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.ArrayList;

public final class NgRfcSerializer
implements SerializationAwareVisitor {
    private final RfcIoOpenCntl act_cntl;
    private final int sendCodepageType;
    private final boolean expensiveCompression;
    private final NgRfcDataCompressionBase compressor;
    private final NgRfcSerializerType typeSerializer;
    private final NgRfcSerializerCompressionColumn compressionColumnSerializer;
    private final NgRfcSerializerColumn standardColumnSerializer;
    private final NgRfcSerializerSimpleColumn simpleColumnSerializer;
    private boolean isChangingParam;

    public NgRfcSerializer(RfcIoOpenCntl act_cntl) {
        this.act_cntl = act_cntl;
        this.expensiveCompression = (act_cntl.serializationFormat & NgRfcUtilCompression.NgRfcCompMask.NGRFC_COMP_OPT.getValue()) != 0;
        Converter converter = new Converter(act_cntl);
        this.sendCodepageType = converter.getSendCodepageType();
        this.compressor = CompressionFactory.createCompressor(act_cntl, converter);
        this.typeSerializer = new NgRfcSerializerType(act_cntl, converter, this.compressor);
        this.compressionColumnSerializer = this.expensiveCompression ? new NgRfcSerializerCompressionColumn(converter, this.compressor, this.typeSerializer) : null;
        this.standardColumnSerializer = new NgRfcSerializerColumn(this.compressor, this.typeSerializer, this);
        this.simpleColumnSerializer = new NgRfcSerializerSimpleColumn(this.compressor, this.typeSerializer);
        this.isChangingParam = false;
    }

    public void serializeSupplyOutAndName(String name, byte supplyOut) throws RfcIoException {
        this.compressor.compressAndWrite(supplyOut);
        byte[] b_name = name.length() > 30 ? name.substring(0, 30).getBytes(Utf8ByteToCharConverter.UTF_8) : name.getBytes(Utf8ByteToCharConverter.UTF_8);
        this.compressor.compressAndWrite((byte)b_name.length);
        this.compressor.compressAndWrite(b_name);
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize supplyOut " + supplyOut + " name " + name + " length " + b_name.length + JCoRuntime.CRLF);
        }
    }

    public void close() throws RfcIoException {
        this.compressor.compressAndWrite(69);
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Close" + JCoRuntime.CRLF);
        }
        this.compressor.close();
    }

    @Override
    public void visit(BgRfcUnit.UnitSerializer bgRfcParam) {
        block2: {
            try {
                this.serializeSupplyOutAndName(bgRfcParam.getParameterList().getMetaData().getName(bgRfcParam.getIndex()), (byte)81);
                this.serializeUnitSerializer(bgRfcParam);
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block2;
                Trc.ab_rfctrc("RfcCall - BgRfc parameter " + bgRfcParam.getName() + " not serialized successful", e);
            }
        }
    }

    private void serializeUnitSerializer(BgRfcUnit.UnitSerializer bgRfcParam) throws RfcIoException {
        DefaultParameterList params = bgRfcParam.getParameterList();
        AbstractMetaData metaData = params.getMetaData();
        int index = bgRfcParam.getIndex();
        this.serializeMetaData(metaData, index);
        byte type = metaData.getTypes()[index];
        if (type != 30) {
            throw new CbRfcException("Wrong type: UnitSerializer has to be defined as type XString, not as " + (Object)((Object)NgRfcType.getTypeForValue(type)));
        }
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize UnitSerializer: type " + type + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(88);
        this.typeSerializer.serializeXStringData(bgRfcParam.getBytes());
    }

    @Override
    public void visit(Parameter p) {
        block4: {
            if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                this.compressor.resetNumWrittenByteCounter();
            }
            try {
                this.serializeSupplyOutAndName(p.getParameterList().getMetaData().getName(p.getIndex()), (byte)81);
                this.serializeParameter(p.getParameterList(), p.getIndex());
                if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                    p.setNumBytes(this.compressor.getCount());
                }
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block4;
                Trc.ab_rfctrc("RfcCall - parameter " + p.getName() + " not serialized successful", e);
            }
        }
    }

    private void serializeParameter(DefaultParameterList paramList, int index) throws RfcIoException {
        this.serializeMetaData(paramList.getMetaData(), index);
        this.serializeField(paramList, index);
    }

    private void serializeMetaData(AbstractMetaData metaData, int index) throws RfcIoException {
        this.compressor.compressAndWrite(68);
        this.compressor.compressAndWrite(0, 1);
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize MD 68 columnCount 1" + JCoRuntime.CRLF);
        }
        this.serializeMetaDataType(metaData, index);
    }

    private void serializeMetaDataType(RecordMetaDataInternal metaData, int index) throws RfcIoException {
        NgRfcType ngrfcType = NgRfcType.NGRFC_UNKNOWN;
        if (metaData != null) {
            ngrfcType = NgRfcType.getNgRfcTypeFromRfcType(metaData.getTypes()[index], this.sendCodepageType == 1);
        }
        this.compressor.compressAndWrite(ngrfcType.getValue());
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize type " + (Object)((Object)ngrfcType) + JCoRuntime.CRLF);
        }
        if (NgRfcType.typeNeedsLength(ngrfcType)) {
            int length = metaData.getLengths()[this.sendCodepageType][index];
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(length));
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize type length " + length + JCoRuntime.CRLF);
            }
        }
        if (metaData != null && ngrfcType == NgRfcType.NGRFC_PBCD) {
            this.compressor.compressAndWrite(metaData.getDecimals()[index]);
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize decimals " + metaData.getDecimals()[index] + JCoRuntime.CRLF);
            }
        }
    }

    private void serializeField(AbstractRecord record, int index) throws RfcIoException {
        if (!record.isInitialized(index)) {
            this.compressor.compressAndWrite(73);
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize initial 73" + JCoRuntime.CRLF);
            }
            return;
        }
        byte type = record.getMetaData().getTypes()[index];
        int length = record.getMetaData().getLengths()[1][index];
        byte compMode = 78;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize field: type " + type + " length " + length + " compMode " + compMode + JCoRuntime.CRLF);
        }
        switch (type) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                this.compressor.compressAndWrite(compMode);
                this.typeSerializer.serializeNumber(record, index, length);
                break;
            }
            case 2: {
                this.compressor.compressAndWrite(compMode);
                this.typeSerializer.serializeBCD(record, index, length);
                break;
            }
            case 4: {
                compMode = length > 21 ? (byte)76 : 78;
                this.compressor.compressAndWrite(compMode);
                this.typeSerializer.serializeBinaryData(record, index, length, compMode);
                break;
            }
            case 23: 
            case 24: {
                this.compressor.compressAndWrite(compMode);
                this.typeSerializer.serializeDecFloat(record, index, length);
                break;
            }
            case 6: {
                this.compressor.compressAndWrite(77);
                this.typeSerializer.serializeNumcData(record, index, length, (byte)77);
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                compMode = length > 4 ? (byte)67 : 79;
                this.compressor.compressAndWrite(compMode);
                this.typeSerializer.serializeCharData(record, index, compMode);
                break;
            }
            case 29: {
                this.compressor.compressAndWrite(83);
                this.typeSerializer.serializeStringData(record, index);
                break;
            }
            case 30: {
                this.compressor.compressAndWrite(88);
                this.typeSerializer.serializeXStringData(record, index);
                break;
            }
            case 99: {
                this.serializeTable(record.decodeTABLE(index), true, true, 0);
                break;
            }
            default: {
                throw new CbRfcException("Wrong type in serializeField " + type);
            }
        }
    }

    @Override
    public void visit(ComplexStructureParameter csp) {
        block4: {
            if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                this.compressor.resetNumWrittenByteCounter();
            }
            try {
                this.serializeSupplyOutAndName(csp.getName(), (byte)81);
                this.serializeNestedType2((DefaultStructure)csp.getComplexParameter());
                if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                    csp.setNumBytes(this.compressor.getCount());
                }
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block4;
                Trc.ab_rfctrc("RfcCall - complex structure parameter " + csp.getName() + " not serialized successful", e);
            }
        }
    }

    protected void serializeNestedType2(DefaultStructure structure) throws RfcIoException {
        DefaultRecordMetaData rmd;
        this.compressor.compressAndWrite(68);
        RecordMetaDataInternal metaData = rmd = structure.getRecordMetaData();
        if (!rmd.containsTable()) {
            metaData = rmd.getType1MetaData();
            assert (metaData != null);
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize nested type 2 structure does not contain a table" + JCoRuntime.CRLF);
            }
        }
        int columnCount = metaData.getFieldCount();
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(columnCount));
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize nested type 2 structure 68 columnCount " + columnCount + JCoRuntime.CRLF);
        }
        this.serializeRecordMetaData(metaData, columnCount, 0);
        this.serializeNested(structure);
    }

    @Override
    public void visit(FlatStructure fs) {
        block2: {
            try {
                this.serializeSupplyOutAndName(fs.getName(), (byte)81);
                this.serializeFlat(fs.getStructure());
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block2;
                Trc.ab_rfctrc("RfcCall - parameter " + fs.getName() + " not serialized successful", e);
            }
        }
    }

    protected void serializeFlat(DefaultStructure structure) throws RfcIoException {
        this.compressor.compressAndWrite(68);
        DefaultRecordMetaData metaData = structure.getRecordMetaData();
        int columnCount = metaData.getFieldCount();
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(columnCount));
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize structure 68 columnCount " + columnCount + JCoRuntime.CRLF);
        }
        this.serializeRecordMetaData(metaData, columnCount, 0);
        for (int i = 0; i < columnCount; ++i) {
            this.serializeField(structure, i);
        }
    }

    @Override
    public void visit(NestedStructure ns) {
        block2: {
            try {
                this.serializeSupplyOutAndName(ns.getName(), (byte)81);
                this.serializeNestedType1(ns.getStructure());
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block2;
                Trc.ab_rfctrc("RfcCall - parameter " + ns.getName() + " not serialized successful", e);
            }
        }
    }

    protected void serializeNestedType1(DefaultStructure structure) throws RfcIoException {
        this.compressor.compressAndWrite(68);
        DefaultRecordMetaData.Type1MetaData metaData = structure.getRecordMetaData().getType1MetaData();
        int columnCount = metaData.getFieldCount();
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(columnCount));
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize nested type 1 structure 68 columnCount " + columnCount + JCoRuntime.CRLF);
        }
        this.serializeRecordMetaData(metaData, columnCount, 0);
        this.serializeNested(structure);
    }

    private void serializeNested(DefaultStructure structure) throws RfcIoException {
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize nested type structure" + JCoRuntime.CRLF + structure + JCoRuntime.CRLF);
        }
        for (int i = 0; i < structure.getMetaData().getFieldCount(); ++i) {
            if (structure.getMetaData().getTypes()[i] == 17) {
                this.serializeNested(structure.decodeSTRUCTURE(i));
                continue;
            }
            this.serializeField(structure, i);
        }
    }

    @Override
    public void visit(ComplexTableParameter ctp) {
        block5: {
            if (this.act_cntl.rfc_role == 'S' && this.isChangingParam && ((DefaultTable)ctp.getComplexParameter()).isOnlyModifiedInNgRfc()) {
                return;
            }
            if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                this.compressor.resetNumWrittenByteCounter();
            }
            try {
                this.serializeSupplyOutAndName(ctp.getName(), (byte)81);
                this.serializeTable((DefaultTable)ctp.getComplexParameter(), false, true, 0);
                if (this.act_cntl.trace || MiddlewareJavaRfc.isMonitorOn()) {
                    ctp.setNumBytes(this.compressor.getCount());
                }
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block5;
                Trc.ab_rfctrc("RfcCall - complex table parameter " + ctp.getName() + " not serialized successful", e);
            }
        }
    }

    @Override
    public void visit(TableParameter tp) {
        block3: {
            if (this.act_cntl.rfc_role == 'S' && tp.getTable().isOnlyModifiedInNgRfc()) {
                return;
            }
            try {
                this.serializeSupplyOutAndName(tp.getName(), (byte)81);
                this.serializeTable(tp.getTable(), false, true, this.act_cntl.useDeltaManagement ? this.act_cntl.getNextTableId(tp) : 0);
            }
            catch (RfcIoException e) {
                if (!this.act_cntl.trace) break block3;
                Trc.ab_rfctrc("RfcCall - table parameter " + tp.getName() + " not serialized successful", e);
            }
        }
    }

    protected void serializeTable(DefaultTable table, boolean isSubTable, boolean isFirstRow, int possibleTableID) throws RfcIoException {
        boolean useHighCompression;
        int columnCount;
        DefaultRecordMetaData recordMetaData = null;
        RecordMetaDataInternal potentialFlatMetaData = null;
        boolean isNestedFlat = false;
        if (table.getNumRows() == 0) {
            columnCount = 0;
        } else {
            recordMetaData = table.getRecordMetaData();
            potentialFlatMetaData = recordMetaData;
            if (!recordMetaData.containsTable() && !recordMetaData.isFlat()) {
                potentialFlatMetaData = recordMetaData.getType1MetaData();
                assert (potentialFlatMetaData != null);
                isNestedFlat = potentialFlatMetaData.getFieldCount() != recordMetaData.getFieldCount();
            }
            columnCount = potentialFlatMetaData.getFieldCount();
        }
        if (isFirstRow) {
            this.compressor.compressAndWrite(isSubTable ? (byte)75 : 68);
        }
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(columnCount | 0x8000));
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(possibleTableID));
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("Serialize table " + (isSubTable ? 75 : 68) + " columnCount " + columnCount + " tableID " + possibleTableID + JCoRuntime.CRLF + table + JCoRuntime.CRLF);
        }
        this.serializeRecordMetaData(potentialFlatMetaData, columnCount, columnCount > 0 ? table.getNumRows() : 0);
        if (columnCount == 0 || table.getNumRows() == 0) {
            return;
        }
        boolean bl = useHighCompression = this.expensiveCompression && table.getNumRows() >= 250;
        if (useHighCompression) {
            this.compressionColumnSerializer.setPosInValueList(new short[table.getNumRows()]);
        }
        int rowSave = table.getRow();
        ArrayList<Integer> indices = new ArrayList<Integer>(10);
        block15: for (int i = 0; i < columnCount; ++i) {
            int length;
            byte type;
            int actualIndex;
            if (isNestedFlat) {
                DefaultRecordMetaData currentStruct = NgRfcUtil.mapFlatToHierarchicalIndex(recordMetaData, i, indices);
                actualIndex = DefaultTable.getNestedTableFieldIndex(indices);
                type = currentStruct.getTypes()[actualIndex];
                length = currentStruct.getLengths()[1][actualIndex];
            } else {
                actualIndex = i;
                type = recordMetaData.getTypes()[i];
                length = recordMetaData.getLengths()[1][i];
            }
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize column " + actualIndex + " type " + type + " length " + length + " isNestedFlat " + isNestedFlat + JCoRuntime.CRLF);
            }
            switch (type) {
                case 0: {
                    byte compMode = NgRfcUtil.getCompModeForCharColumn(length);
                    if (this.simpleColumnSerializer.serializeCharColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeCharColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeCharColumn(table, actualIndex, compMode, isNestedFlat, indices);
                    continue block15;
                }
                case 4: {
                    byte compMode;
                    byte by = compMode = length > 15 ? (byte)76 : 78;
                    if (this.simpleColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices);
                    continue block15;
                }
                case 2: 
                case 7: 
                case 23: 
                case 24: {
                    byte compMode = 78;
                    if (this.simpleColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeByteColumn(table, actualIndex, compMode, length, isNestedFlat, indices);
                    continue block15;
                }
                case 6: {
                    byte compMode = 71;
                    if (this.simpleColumnSerializer.serializeNumColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeNumColumn(table, actualIndex, compMode, length, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeNumColumn(table, actualIndex, compMode, length, isNestedFlat, indices);
                    continue block15;
                }
                case 29: {
                    byte compMode = 83;
                    if (this.simpleColumnSerializer.serializeStringColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeStringColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeStringColumn(table, actualIndex, compMode, isNestedFlat, indices);
                    continue block15;
                }
                case 30: {
                    byte compMode = 88;
                    if (this.simpleColumnSerializer.serializeXStringColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression && this.compressionColumnSerializer.serializeXStringColumn(table, actualIndex, compMode, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeXStringColumn(table, actualIndex, compMode, isNestedFlat, indices);
                    continue block15;
                }
                case 1: {
                    if (this.simpleColumnSerializer.serializeDateColumn(table, actualIndex, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeDateColumn(table, actualIndex, isNestedFlat, indices)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        if (!NgRfcUtil.containsInvalidDateChars(table, isNestedFlat, actualIndex, indices)) {
                            this.standardColumnSerializer.serializeDateColumn(table, actualIndex, isNestedFlat, indices);
                            continue block15;
                        }
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No date compression active" + JCoRuntime.CRLF);
                    }
                    byte compMode = NgRfcUtil.getCompModeForCharColumn(length);
                    this.standardColumnSerializer.serializeCharColumn(table, actualIndex, compMode, isNestedFlat, indices);
                    continue block15;
                }
                case 3: {
                    if (this.simpleColumnSerializer.serializeTimeColumn(table, actualIndex, isNestedFlat, indices)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeTimeColumn(table, actualIndex, isNestedFlat, indices)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        if (!NgRfcUtil.containsInvalidTimeChars(table, isNestedFlat, actualIndex, indices)) {
                            this.standardColumnSerializer.serializeTimeColumn(table, actualIndex, isNestedFlat, indices);
                            continue block15;
                        }
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No time compression active" + JCoRuntime.CRLF);
                    }
                    byte compMode = NgRfcUtil.getCompModeForCharColumn(length);
                    this.standardColumnSerializer.serializeCharColumn(table, actualIndex, compMode, isNestedFlat, indices);
                    continue block15;
                }
                case 10: {
                    if (this.simpleColumnSerializer.serializeInt1Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeInt1Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        this.standardColumnSerializer.serializeInt1Column(table, actualIndex, isNestedFlat, indices, (short)-1);
                        continue block15;
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No int compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeInt1ColumnWithoutCompression(table, actualIndex, isNestedFlat, indices);
                    continue block15;
                }
                case 9: 
                case 58: 
                case 59: {
                    if (this.simpleColumnSerializer.serializeInt2Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeInt2Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        this.standardColumnSerializer.serializeInt2Column(table, actualIndex, isNestedFlat, indices, (short)-1);
                        continue block15;
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No int compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeInt2ColumnWithoutCompression(table, actualIndex, isNestedFlat, indices);
                    continue block15;
                }
                case 8: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.simpleColumnSerializer.serializeInt4Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeInt4Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        this.standardColumnSerializer.serializeInt4Column(table, actualIndex, isNestedFlat, indices, (short)-1);
                        continue block15;
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No int compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeInt4ColumnWithoutCompression(table, actualIndex, isNestedFlat, indices);
                    continue block15;
                }
                case 40: 
                case 51: 
                case 52: 
                case 53: {
                    if (this.simpleColumnSerializer.serializeInt8Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No simple Column possible" + JCoRuntime.CRLF);
                    }
                    if (useHighCompression) {
                        if (this.compressionColumnSerializer.serializeInt8Column(table, actualIndex, isNestedFlat, indices, (short)-1)) continue block15;
                        if (this.act_cntl.trace) {
                            Trc.ab_rfctrc("No value compression active" + JCoRuntime.CRLF);
                        }
                        this.standardColumnSerializer.serializeInt8Column(table, actualIndex, isNestedFlat, indices, (short)-1);
                        continue block15;
                    }
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("No int compression active" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeInt8ColumnWithoutCompression(table, actualIndex, isNestedFlat, indices);
                    continue block15;
                }
                case 99: {
                    if (this.act_cntl.trace) {
                        Trc.ab_rfctrc("serialize Subtable" + JCoRuntime.CRLF);
                    }
                    this.standardColumnSerializer.serializeTableColumn(table, actualIndex, isNestedFlat, indices);
                    continue block15;
                }
                default: {
                    throw new CbRfcException("Wrong type in serializeTable: " + type);
                }
            }
        }
        table.setRow(rowSave);
    }

    private void serializeRecordMetaData(RecordMetaDataInternal metaData, int columnCount, int rowCount) throws RfcIoException {
        for (int i = 0; i < columnCount; ++i) {
            this.serializeMetaDataType(metaData, i);
        }
        if (rowCount > 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("Serialize rowCount " + rowCount + JCoRuntime.CRLF);
            }
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(rowCount < 65535 ? rowCount : 65535));
            if (rowCount >= 65535) {
                this.compressor.compressAndWrite(RfcUtilities.longAsByteArray(rowCount));
            }
        }
    }

    public void setChangingParam(boolean isChangingParam) {
        this.isChangingParam = isChangingParam;
    }
}

