/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.sendStream.BitsWriter;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializer;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerColumnBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.ArrayList;

public final class NgRfcSerializerColumn
extends NgRfcSerializerColumnBase {
    private final NgRfcSerializer serializer;
    private long minValue;

    public NgRfcSerializerColumn(NgRfcDataCompressionBase compressor, NgRfcSerializerType typeSerializer, NgRfcSerializer serializer) {
        super(compressor, typeSerializer);
        this.serializer = serializer;
    }

    @Override
    protected boolean serializeDateColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        byte bitCount = this.getBitCountOfDateDiff(table, isNestedFlat, indices, index);
        this.compressor.compressAndWrite(74);
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray((int)this.minValue));
        this.compressor.compressAndWrite(bitCount);
        table.firstRow();
        BitsWriter bw = new BitsWriter(this.compressor);
        do {
            long ll = NgRfcUtil.convertDateToBits(table.getFieldRecord(isNestedFlat, indices, false).decodeCHAR(index), this.minValue, bitCount);
            bw.writeLongBits(ll, bitCount);
        } while (table.nextRow());
        bw.flushLLBits();
        return true;
    }

    private byte getBitCountOfDateDiff(DefaultTable table, boolean isNestedFlat, ArrayList<Integer> indices, int actualIndex) {
        byte bitCount = 0;
        char[] minYear = new char[]{'9', '9', '9', '9'};
        char[] maxYear = new char[]{' ', ' ', ' ', ' '};
        this.minValue = Long.MAX_VALUE;
        table.firstRow();
        do {
            char[] year;
            if (this.compareDates(year = table.getFieldRecord(isNestedFlat, indices, false).decodeCHARARRAY_WITH_LENGTH(actualIndex, 4), minYear) < 0) {
                minYear = year;
            }
            if (this.compareDates(year, maxYear) <= 0) continue;
            maxYear = year;
        } while (table.nextRow());
        this.minValue = NgRfcUtil.convertYearToInt8(minYear);
        bitCount = NgRfcUtil.getBitCountOfIntDiff(this.minValue, NgRfcUtil.convertYearToInt8(maxYear));
        bitCount = (byte)(bitCount + 9);
        return bitCount;
    }

    private int compareDates(char[] year, char[] minYear) {
        for (int i = 0; i < year.length; ++i) {
            if (year[i] == minYear[i]) continue;
            return year[i] - minYear[i];
        }
        return 0;
    }

    @Override
    protected boolean serializeTimeColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(72);
        table.firstRow();
        BitsWriter bw = new BitsWriter(this.compressor);
        do {
            long ll = NgRfcUtil.convertTimeToBits(table.getFieldRecord(isNestedFlat, indices, false).decodeCHARARRAY(index));
            bw.writeLongBits(ll, (short)17);
        } while (table.nextRow());
        bw.flushLLBits();
        return true;
    }

    @Override
    protected boolean serializeCharColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(compMode);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.typeSerializer.serializeCharData(actualRec, index, compMode);
        } while (table.nextRow());
        return true;
    }

    @Override
    protected boolean serializeByteColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(compMode);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.typeSerializer.serializeBinaryData(actualRec, index, length, compMode);
        } while (table.nextRow());
        return true;
    }

    @Override
    protected boolean serializeNumColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(compMode);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.typeSerializer.serializeNumcData(actualRec, index, length, compMode);
        } while (table.nextRow());
        return true;
    }

    @Override
    protected boolean serializeStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(compMode);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.typeSerializer.serializeStringData(actualRec, index);
        } while (table.nextRow());
        return true;
    }

    @Override
    protected boolean serializeXStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(compMode);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.typeSerializer.serializeXStringData(actualRec, index);
        } while (table.nextRow());
        return true;
    }

    protected void serializeInt1ColumnWithoutCompression(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(78);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.compressor.compressAndWrite((byte)actualRec.decodeINT(index));
        } while (table.nextRow());
    }

    protected void serializeInt2ColumnWithoutCompression(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(78);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(actualRec.decodeINT(index)));
        } while (table.nextRow());
    }

    protected void serializeInt4ColumnWithoutCompression(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(78);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.compressor.compressAndWrite(RfcUtilities.intAsByteArray(actualRec.decodeINT(index)));
        } while (table.nextRow());
    }

    protected void serializeInt8ColumnWithoutCompression(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        this.compressor.compressAndWrite(78);
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.compressor.compressAndWrite(RfcUtilities.longAsByteArray(actualRec.decodeLONG(index)));
        } while (table.nextRow());
    }

    protected void serializeTableColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        boolean isFirstRow = true;
        table.firstRow();
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            this.serializer.serializeTable(actualRec.decodeTABLE(index), true, isFirstRow, 0);
            isFirstRow = false;
        } while (table.nextRow());
    }

    @Override
    protected long[] getLongMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        table.firstRow();
        long maxValue = Long.MIN_VALUE;
        long minValue = Long.MAX_VALUE;
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            long value = actualRec.decodeLONG(index);
            minValue = Math.min(minValue, value);
            maxValue = Math.max(maxValue, value);
        } while (table.nextRow());
        return new long[]{minValue, maxValue};
    }

    @Override
    protected int[] getIntMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        table.firstRow();
        int maxValue = Integer.MIN_VALUE;
        int minValue = Integer.MAX_VALUE;
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            int value = actualRec.decodeINT(index);
            minValue = Math.min(minValue, value);
            maxValue = Math.max(maxValue, value);
        } while (table.nextRow());
        return new int[]{minValue, maxValue};
    }

    @Override
    protected void serializeLongBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(bitCount);
        table.firstRow();
        BitsWriter bw = new BitsWriter(this.compressor);
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            long value = actualRec.decodeLONG(index);
            bw.writeLongBits(value - minValue, bitCount);
        } while (table.nextRow());
        bw.flushLLBits();
    }

    @Override
    protected void serializeIntBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(bitCount);
        table.firstRow();
        BitsWriter bw = new BitsWriter(this.compressor);
        do {
            AbstractRecord actualRec = table.getFieldRecord(isNestedFlat, indices, false);
            long value = actualRec.decodeINT(index);
            bw.writeLongBits(value - minValue, bitCount);
        } while (table.nextRow());
        bw.flushLLBits();
    }
}

