/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.ArrayList;

public abstract class NgRfcSerializerColumnBase {
    protected final NgRfcDataCompressionBase compressor;
    protected final NgRfcSerializerType typeSerializer;

    public NgRfcSerializerColumnBase(NgRfcDataCompressionBase compressor, NgRfcSerializerType serializerType) {
        this.compressor = compressor;
        this.typeSerializer = serializerType;
    }

    protected abstract boolean serializeDateColumn(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4) throws RfcIoException;

    protected abstract boolean serializeTimeColumn(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4) throws RfcIoException;

    protected abstract boolean serializeCharColumn(DefaultTable var1, int var2, byte var3, boolean var4, ArrayList<Integer> var5) throws RfcIoException;

    protected abstract boolean serializeByteColumn(DefaultTable var1, int var2, byte var3, int var4, boolean var5, ArrayList<Integer> var6) throws RfcIoException;

    protected abstract boolean serializeNumColumn(DefaultTable var1, int var2, byte var3, int var4, boolean var5, ArrayList<Integer> var6) throws RfcIoException;

    protected abstract boolean serializeStringColumn(DefaultTable var1, int var2, byte var3, boolean var4, ArrayList<Integer> var5) throws RfcIoException;

    protected abstract boolean serializeXStringColumn(DefaultTable var1, int var2, byte var3, boolean var4, ArrayList<Integer> var5) throws RfcIoException;

    protected abstract long[] getLongMinAndMaxValues(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4, short var5);

    protected abstract int[] getIntMinAndMaxValues(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4, short var5);

    protected abstract void serializeLongBits(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4, long var5, byte var7, short var8) throws RfcIoException;

    protected abstract void serializeIntBits(DefaultTable var1, int var2, boolean var3, ArrayList<Integer> var4, long var5, byte var7, short var8) throws RfcIoException;

    protected boolean serializeInt1Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(50);
        int[] minMax = this.getIntMinAndMaxValues(table, index, isNestedFlat, indices, numDiffValues);
        byte bitCount = NgRfcUtil.getBitCountOfIntDiff(minMax[0], minMax[1]);
        this.compressor.compressAndWrite((byte)minMax[0]);
        this.serializeIntBits(table, index, isNestedFlat, indices, minMax[0], bitCount, numDiffValues);
        return true;
    }

    protected boolean serializeInt2Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(50);
        int[] minMax = this.getIntMinAndMaxValues(table, index, isNestedFlat, indices, numDiffValues);
        byte bitCount = NgRfcUtil.getBitCountOfIntDiff(minMax[0], minMax[1]);
        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray((short)minMax[0]));
        this.serializeIntBits(table, index, isNestedFlat, indices, minMax[0], bitCount, numDiffValues);
        return true;
    }

    protected boolean serializeInt4Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(50);
        int[] minMax = this.getIntMinAndMaxValues(table, index, isNestedFlat, indices, numDiffValues);
        byte bitCount = NgRfcUtil.getBitCountOfIntDiff(minMax[0], minMax[1]);
        this.compressor.compressAndWrite(RfcUtilities.intAsByteArray(minMax[0]));
        this.serializeIntBits(table, index, isNestedFlat, indices, minMax[0], bitCount, numDiffValues);
        return true;
    }

    protected boolean serializeInt8Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        this.compressor.compressAndWrite(50);
        long[] minMax = this.getLongMinAndMaxValues(table, index, isNestedFlat, indices, numDiffValues);
        byte bitCount = NgRfcUtil.getBitCountOfIntDiff(minMax[0], minMax[1]);
        this.compressor.compressAndWrite(RfcUtilities.longAsByteArray(minMax[0]));
        this.serializeLongBits(table, index, isNestedFlat, indices, minMax[0], bitCount, numDiffValues);
        return true;
    }
}

