/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.sendStream.BitsWriter;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerColumnBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerType;
import com.sap.conn.rfc.engine.ngrfc.util.NgRfcUtil;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.ArrayList;

public final class NgRfcSerializerCompressionColumn
extends NgRfcSerializerColumnBase {
    private final int[] tableDataRowIndices = new int[256];
    private short[] posInValueList;

    public NgRfcSerializerCompressionColumn(Converter converter, NgRfcDataCompressionBase compressor, NgRfcSerializerType typeSerializer) {
        super(compressor, typeSerializer);
    }

    protected void setPosInValueList(short[] posInValueList) {
        this.posInValueList = posInValueList;
    }

    @Override
    protected boolean serializeCharColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        int numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        this.compressor.compressAndWrite(compMode);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            this.typeSerializer.serializeCharData(table.getFieldRecord(isNestedFlat, indices, false), index, compMode);
        }
        this.writeValueListPositions((short)numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeByteColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        int numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        this.compressor.compressAndWrite(compMode);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            this.typeSerializer.serializeBinaryData(table.getFieldRecord(isNestedFlat, indices, false), index, length, compMode);
        }
        this.writeValueListPositions((short)numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeNumColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        int numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        this.compressor.compressAndWrite(compMode);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            this.typeSerializer.serializeNumcData(table.getFieldRecord(isNestedFlat, indices, false), index, length, compMode);
        }
        this.writeValueListPositions((short)numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        int numDiffValues = this.getNumberOfDifferentStringValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        this.compressor.compressAndWrite(compMode);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            this.typeSerializer.serializeStringData(table.getFieldRecord(isNestedFlat, indices, false), index);
        }
        this.writeValueListPositions((short)numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeXStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        int numDiffValues = this.getNumberOfDifferentXStringValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        this.compressor.compressAndWrite(compMode);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            this.typeSerializer.serializeXStringData(table.getFieldRecord(isNestedFlat, indices, false), index);
        }
        this.writeValueListPositions((short)numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeDateColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        return this.serializeCharColumn(table, index, (byte)67, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeTimeColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        return this.serializeCharColumn(table, index, (byte)67, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeInt1Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        super.serializeInt1Column(table, index, isNestedFlat, indices, numDiffValues);
        this.writeValueListPositions(numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeInt2Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        super.serializeInt2Column(table, index, isNestedFlat, indices, numDiffValues);
        this.writeValueListPositions(numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeInt4Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        super.serializeInt4Column(table, index, isNestedFlat, indices, numDiffValues);
        this.writeValueListPositions(numDiffValues);
        return true;
    }

    @Override
    protected boolean serializeInt8Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        numDiffValues = this.getNumberOfDifferentPrimitiveValues(table, index, isNestedFlat, indices);
        if (numDiffValues >= 255) {
            return false;
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite((byte)numDiffValues);
        super.serializeInt8Column(table, index, isNestedFlat, indices, numDiffValues);
        this.writeValueListPositions(numDiffValues);
        return true;
    }

    private void writeValueListPositions(short numDiffValues) throws RfcIoException {
        short bitCount = NgRfcUtil.getBitCountFromValues(numDiffValues);
        BitsWriter bitsWriter = new BitsWriter(this.compressor);
        for (int i = 0; i < this.posInValueList.length; ++i) {
            bitsWriter.writeRawBits(this.posInValueList[i], bitCount);
        }
        bitsWriter.flushRawBits();
    }

    private short getNumberOfDifferentPrimitiveValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) {
        short numDiffValues = 1;
        table.firstRow();
        assert (table.getNumRows() > 1);
        if (isNestedFlat) {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInPrimitiveValueListNested(table.getRow(), numDiffValues, index, indices, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        } else {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInPrimitiveValueList(table.getRow(), numDiffValues, index, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        }
        return numDiffValues;
    }

    private short getNumberOfDifferentStringValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) {
        short numDiffValues = 1;
        table.firstRow();
        assert (table.getNumRows() > 1);
        if (isNestedFlat) {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInStringValueListNested(table.getRow(), numDiffValues, index, indices, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        } else {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInStringValueList(table.getRow(), numDiffValues, index, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        }
        return numDiffValues;
    }

    private short getNumberOfDifferentXStringValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) {
        short numDiffValues = 1;
        table.firstRow();
        assert (table.getNumRows() > 1);
        if (isNestedFlat) {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInXStringValueListNested(table.getRow(), numDiffValues, index, indices, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        } else {
            while (table.nextRow() && numDiffValues <= 255) {
                short posInValList = table.posInXStringValueList(table.getRow(), numDiffValues, index, this.tableDataRowIndices);
                if (posInValList == -1) {
                    this.tableDataRowIndices[numDiffValues] = table.getRow();
                    this.posInValueList[table.getRow()] = numDiffValues;
                    numDiffValues = (short)(numDiffValues + 1);
                    continue;
                }
                this.posInValueList[table.getRow()] = posInValList;
            }
        }
        return numDiffValues;
    }

    @Override
    protected long[] getLongMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        long maxValue = Long.MIN_VALUE;
        long minValue = Long.MAX_VALUE;
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            long value = table.getFieldRecord(isNestedFlat, indices, false).decodeLONG(index);
            minValue = Math.min(value, minValue);
            maxValue = Math.max(value, maxValue);
        }
        return new long[]{minValue, maxValue};
    }

    @Override
    protected int[] getIntMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        int maxValue = Integer.MIN_VALUE;
        int minValue = Integer.MAX_VALUE;
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            int value = table.getFieldRecord(isNestedFlat, indices, false).decodeINT(index);
            minValue = Math.min(value, minValue);
            maxValue = Math.max(value, maxValue);
        }
        return new int[]{minValue, maxValue};
    }

    @Override
    protected void serializeLongBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        BitsWriter bitsWriter = new BitsWriter(this.compressor);
        this.compressor.compressAndWrite(bitCount);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            long ll = table.getFieldRecord(isNestedFlat, indices, false).decodeLONG(index);
            bitsWriter.writeLongBits(ll - minValue, bitCount);
        }
        bitsWriter.flushLLBits();
    }

    @Override
    protected void serializeIntBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        BitsWriter bitsWriter = new BitsWriter(this.compressor);
        this.compressor.compressAndWrite(bitCount);
        for (int i = 0; i < numDiffValues; ++i) {
            table.setRow(this.tableDataRowIndices[i]);
            int ll = table.getFieldRecord(isNestedFlat, indices, false).decodeINT(index);
            bitsWriter.writeLongBits((long)ll - minValue, bitCount);
        }
        bitsWriter.flushLLBits();
    }
}

