/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerColumnBase;
import com.sap.conn.rfc.engine.ngrfc.serialize.NgRfcSerializerType;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.ArrayList;

public final class NgRfcSerializerSimpleColumn
extends NgRfcSerializerColumnBase {
    public NgRfcSerializerSimpleColumn(NgRfcDataCompressionBase compressor, NgRfcSerializerType typeSerializer) {
        super(compressor, typeSerializer);
    }

    @Override
    protected boolean serializeCharColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        char[] value;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInPrimitiveColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            value = table.decodeCHARARRAY(index);
        } else {
            table.firstRow();
            AbstractRecord actualRec = table.getNestedFieldRecord(indices, false);
            if (!table.equalValuesInPrimitiveColumnNested(index, indices, actualRec)) {
                return false;
            }
            value = actualRec.decodeCHARARRAY(index);
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        this.compressor.compressAndWrite(compMode);
        this.typeSerializer.serializeCharData(value, compMode);
        return true;
    }

    @Override
    protected boolean serializeByteColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        AbstractRecord actualRec;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInPrimitiveColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            actualRec = table;
        } else {
            table.firstRow();
            actualRec = table.getNestedFieldRecord(indices, false);
            if (!table.equalValuesInPrimitiveColumnNested(index, indices, actualRec)) {
                return false;
            }
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        this.compressor.compressAndWrite(compMode);
        this.typeSerializer.serializeBinaryData(actualRec, index, length, compMode);
        return true;
    }

    @Override
    protected boolean serializeNumColumn(DefaultTable table, int index, byte compMode, int length, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        AbstractRecord actualRec;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInPrimitiveColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            actualRec = table;
        } else {
            table.firstRow();
            actualRec = table.getNestedFieldRecord(indices, false);
            if (!table.equalValuesInPrimitiveColumnNested(index, indices, actualRec)) {
                return false;
            }
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        this.compressor.compressAndWrite(compMode);
        this.typeSerializer.serializeNumcData(actualRec, index, length, compMode);
        return true;
    }

    @Override
    protected boolean serializeStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        String value;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInStringColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            DefaultTable actualRec = table;
            value = table.decodeSTRING(index);
        } else {
            table.firstRow();
            AbstractRecord actualRec = table.getNestedFieldRecord(indices, false);
            value = actualRec.decodeSTRING(index);
            if (!table.equalValuesInStringColumnNested(index, indices, value)) {
                return false;
            }
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        this.compressor.compressAndWrite(compMode);
        this.typeSerializer.serializeStringData(value);
        return true;
    }

    @Override
    protected boolean serializeXStringColumn(DefaultTable table, int index, byte compMode, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        byte[] value;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInXStringColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            DefaultTable actualRec = table;
            value = table.decodeXSTRING(index);
        } else {
            table.firstRow();
            AbstractRecord actualRec = table.getNestedFieldRecord(indices, false);
            value = actualRec.decodeXSTRING(index);
            if (!table.equalValuesInXStringColumnNested(index, indices, value)) {
                return false;
            }
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        this.compressor.compressAndWrite(compMode);
        this.typeSerializer.serializeXStringData(value);
        return true;
    }

    @Override
    protected boolean serializeDateColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        return this.serializeCharColumn(table, index, (byte)67, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeTimeColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        return this.serializeCharColumn(table, index, (byte)67, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeInt1Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        return this.serializeSimpleIntColumn(table, index, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeInt2Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        return this.serializeSimpleIntColumn(table, index, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeInt4Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        return this.serializeSimpleIntColumn(table, index, isNestedFlat, indices);
    }

    @Override
    protected boolean serializeInt8Column(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) throws RfcIoException {
        return this.serializeSimpleIntColumn(table, index, isNestedFlat, indices);
    }

    private boolean serializeSimpleIntColumn(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices) throws RfcIoException {
        AbstractRecord actualRec;
        if (!isNestedFlat) {
            if (!table.isInitialized(index)) {
                this.compressor.compressAndWrite(73);
                return true;
            }
            if (!table.isSameValue(index) && !table.equalValuesInPrimitiveColumn(index)) {
                return false;
            }
            table.changeSameValueFlag(index, true);
            table.firstRow();
            actualRec = table;
        } else {
            table.firstRow();
            actualRec = table.getNestedFieldRecord(indices, false);
            if (!table.equalValuesInPrimitiveColumnNested(index, indices, actualRec)) {
                return false;
            }
        }
        this.compressor.compressAndWrite(86);
        this.compressor.compressAndWrite(1);
        int length = actualRec.getMetaData().getLengths()[1][index];
        this.compressor.compressAndWrite(78);
        this.typeSerializer.serializeNumber(actualRec, index, length);
        return true;
    }

    @Override
    protected long[] getLongMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        throw new CbRfcException("Wrong call");
    }

    @Override
    protected int[] getIntMinAndMaxValues(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, short numDiffValues) {
        throw new CbRfcException("Wrong call");
    }

    @Override
    protected void serializeLongBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        throw new CbRfcException("Wrong call");
    }

    @Override
    protected void serializeIntBits(DefaultTable table, int index, boolean isNestedFlat, ArrayList<Integer> indices, long minValue, byte bitCount, short numDiffValues) throws RfcIoException {
        throw new CbRfcException("Wrong call");
    }
}

