/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.serialize;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcUtilities;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.engine.ngrfc.compress.NgRfcDataCompressionBase;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.util.Arrays;

public final class NgRfcSerializerType {
    private final boolean trace;
    private final boolean shouldSendInUTF8;
    private final Converter converter;
    private final NgRfcDataCompressionBase compressor;

    protected NgRfcSerializerType(RfcIoOpenCntl act_cntl, Converter converter, NgRfcDataCompressionBase compressor) {
        this.trace = act_cntl.trace;
        this.shouldSendInUTF8 = act_cntl.pcs > 1 && !act_cntl.lang.startsWith("1") && !act_cntl.lang.startsWith("3") && !act_cntl.lang.startsWith("J") && !act_cntl.lang.startsWith("M");
        this.converter = converter;
        this.compressor = compressor;
    }

    protected void serializeNumber(AbstractRecord record, int index, int length) throws RfcIoException {
        byte[] result = new byte[length];
        this.converter.decodeNumber(record, result, index, 0, length);
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeNumber " + Arrays.toString(result) + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(result, 0, length);
    }

    protected void serializeBCD(AbstractRecord record, int index, int length) throws RfcIoException {
        byte[] result = new byte[length];
        this.converter.decodeBinary(record, result, index, 0, length);
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeBCD " + Arrays.toString(result) + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(result, 0, length);
    }

    protected void serializeDecFloat(AbstractRecord record, int index, int length) throws RfcIoException {
        byte[] result = new byte[length];
        this.converter.decodeDecNumber(record, result, index, 0, length);
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeDecFloat " + Arrays.toString(result) + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(result, 0, length);
    }

    protected void serializeBinaryData(AbstractRecord record, int index, int length, byte compMode) throws RfcIoException {
        int byteLength;
        byte[] result = new byte[length];
        this.converter.decodeBinary(record, result, index, 0, length);
        if (compMode == 76) {
            for (byteLength = length; byteLength > 0 && result[byteLength - 1] == 0; --byteLength) {
            }
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(byteLength));
        }
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeBinaryData " + Arrays.toString(result) + " length " + byteLength + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(result, 0, byteLength);
    }

    protected void serializeNumcData(AbstractRecord record, int index, int length, byte compMode) throws RfcIoException {
        int offset;
        byte[] tmpValArr = new byte[length];
        this.converter.decodeChar(record, tmpValArr, index, 0, length);
        if (compMode == 71) {
            for (offset = 0; offset < tmpValArr.length && tmpValArr[offset] == 0; ++offset) {
            }
        }
        byte[] nibbles = new byte[(length - offset) / 2 + 1];
        int digits = 0;
        int j = 0;
        while (offset < tmpValArr.length) {
            block14: {
                int tmp = tmpValArr[offset];
                switch (tmp) {
                    case 32: {
                        tmp = 10;
                        break;
                    }
                    case 95: {
                        tmp = 11;
                        break;
                    }
                    case 45: {
                        tmp = 12;
                        break;
                    }
                    case 58: {
                        tmp = 13;
                        break;
                    }
                    case 46: {
                        tmp = 14;
                        break;
                    }
                    case 43: {
                        tmp = 15;
                        break;
                    }
                    default: {
                        if (tmp < 48 || tmp > 57) break block14;
                        tmp = (byte)(tmp - 48);
                    }
                }
                int n = j++;
                nibbles[n] = (byte)(nibbles[n] | tmp << ++digits % 2 * 4);
                if (digits % 2 == 0) {
                    // empty if block
                }
            }
            ++offset;
        }
        if (compMode == 71) {
            this.compressor.compressAndWrite((byte)digits);
        }
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeNumcData " + Arrays.toString(nibbles) + " digits " + digits + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(nibbles, 0, digits / 2 + digits % 2);
    }

    protected void serializeCharData(AbstractRecord record, int index, byte compMode) throws RfcIoException {
        this.serializeCharData(record.decodeCHARARRAY(index), compMode);
    }

    protected void serializeCharData(char[] charData, byte compMode) throws RfcIoException {
        byte[] byteData = null;
        if (compMode == 67) {
            int trimmedLength = NgRfcSerializerType.getTrimmedLength(charData);
            if (this.shouldSendInUTF8) {
                byteData = new String(charData, 0, trimmedLength).getBytes(Utf8ByteToCharConverter.UTF_8);
                this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(byteData.length | 0x8000));
            } else {
                byteData = this.converter.decodeCharArray(charData, trimmedLength);
                this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(byteData.length));
            }
        } else {
            byteData = this.converter.decodeCharArray(charData, charData.length);
        }
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeCharData " + Arrays.toString(charData) + " compMode " + compMode + " UTF8 " + this.shouldSendInUTF8 + " bytes " + Arrays.toString(byteData) + JCoRuntime.CRLF);
        }
        this.compressor.compressAndWrite(byteData);
    }

    private static int getTrimmedLength(char[] data) {
        int i;
        for (i = data.length - 1; i >= 0 && data[i] == ' '; --i) {
        }
        return i + 1;
    }

    protected void serializeStringData(AbstractRecord record, int index) throws RfcIoException {
        this.serializeStringData(record.decodeSTRING(index));
    }

    protected void serializeStringData(String value) throws RfcIoException {
        int bytesToWrite;
        if (value == null) {
            if (this.trace) {
                Trc.ab_rfctrc("\tserializeStringData null string " + JCoRuntime.CRLF);
            }
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(0));
            return;
        }
        int characterLength = value.length();
        if (characterLength == 0) {
            if (this.trace) {
                Trc.ab_rfctrc("\tserializeStringData empty string " + JCoRuntime.CRLF);
            }
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(0));
            return;
        }
        byte[] byteValues = this.converter.decodeString(value);
        int dataLength = byteValues.length;
        boolean hasSendInUtf8 = false;
        if (this.shouldSendInUTF8) {
            byteValues = value.getBytes(Utf8ByteToCharConverter.UTF_8);
            dataLength = byteValues.length;
            hasSendInUtf8 = true;
        }
        boolean isLastBlock = false;
        boolean isFirstBlock = true;
        for (int currentBytePos = 0; currentBytePos < dataLength; currentBytePos += bytesToWrite) {
            int bufferSize = isFirstBlock ? 16383 : Short.MAX_VALUE;
            int maskedDataLength = bytesToWrite = Math.min(bufferSize, dataLength - currentBytePos);
            boolean bl = isLastBlock = currentBytePos + bufferSize >= dataLength;
            if (isFirstBlock) {
                if (hasSendInUtf8) {
                    maskedDataLength |= 0x8000;
                }
                if (isLastBlock) {
                    maskedDataLength |= 0x4000;
                }
                this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(maskedDataLength));
                if (hasSendInUtf8 || !isLastBlock) {
                    if (characterLength >= 65535) {
                        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(65535));
                        this.compressor.compressAndWrite(RfcUtilities.intAsByteArray(characterLength));
                    } else {
                        this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(characterLength));
                    }
                }
            } else {
                if (isLastBlock) {
                    maskedDataLength |= 0x8000;
                }
                this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(maskedDataLength));
            }
            if (this.trace) {
                Trc.ab_rfctrc("\tserializeStringData " + Arrays.toString(byteValues) + " currentBytePos " + currentBytePos + " UTF8 " + this.shouldSendInUTF8 + " bytesToWrite " + bytesToWrite + " maskedDataLength " + maskedDataLength + " characterLength " + characterLength + JCoRuntime.CRLF);
            }
            this.compressor.compressAndWrite(byteValues, currentBytePos, bytesToWrite);
            isFirstBlock = false;
        }
    }

    protected void serializeXStringData(AbstractRecord record, int index) throws RfcIoException {
        this.serializeXStringData(record.decodeXSTRING(index));
    }

    protected void serializeXStringData(byte[] data) throws RfcIoException {
        int numBytes;
        int n = numBytes = data == null ? 0 : data.length;
        if (numBytes >= 65535) {
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(65535));
            this.compressor.compressAndWrite(RfcUtilities.intAsByteArray(numBytes));
        } else {
            this.compressor.compressAndWrite(RfcUtilities.shortAsByteArray(numBytes));
        }
        if (this.trace) {
            Trc.ab_rfctrc("\tserializeXStringData " + Arrays.toString(data) + " numBytes " + numBytes + JCoRuntime.CRLF);
        }
        if (data != null) {
            this.compressor.compressAndWrite(data);
        }
    }
}

