/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.util;

public enum NgRfcType {
    NGRFC_UNKNOWN(0),
    NGRFC_INT1(1),
    NGRFC_INT2(2),
    NGRFC_INT4(3),
    NGRFC_INT8(4),
    NGRFC_CHAR1(5),
    NGRFC_CHAR2(6),
    NGRFC_NUM1(7),
    NGRFC_NUM2(8),
    NGRFC_PBCD(9),
    NGRFC_DATE1(11),
    NGRFC_DATE2(12),
    NGRFC_TIME1(13),
    NGRFC_TIME2(14),
    NGRFC_BIN_FLOAT64(19),
    NGRFC_DEC_FLOAT64(21),
    NGRFC_DEC_FLOAT128(22),
    NGRFC_RAW(23),
    NGRFC_STRING(24),
    NGRFC_XSTRING(25),
    NGRFC_STRUCTURE(26),
    NGRFC_TABLE(27),
    NGRFC_STRUCTURE_REF(28);

    private byte value;

    private NgRfcType(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public static NgRfcType getTypeForValue(byte num) {
        for (NgRfcType type : NgRfcType.values()) {
            if (type.value != num) continue;
            return type;
        }
        return null;
    }

    public static NgRfcType getNgRfcTypeFromRfcType(byte irfcParamType, boolean isUnicode) {
        switch (irfcParamType) {
            case 0: {
                return isUnicode ? NGRFC_CHAR2 : NGRFC_CHAR1;
            }
            case 1: {
                return isUnicode ? NGRFC_DATE2 : NGRFC_DATE1;
            }
            case 2: {
                return NGRFC_PBCD;
            }
            case 3: {
                return isUnicode ? NGRFC_TIME2 : NGRFC_TIME1;
            }
            case 4: {
                return NGRFC_RAW;
            }
            case 6: {
                return isUnicode ? NGRFC_NUM2 : NGRFC_NUM1;
            }
            case 7: {
                return NGRFC_BIN_FLOAT64;
            }
            case 8: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return NGRFC_INT4;
            }
            case 9: 
            case 58: 
            case 59: {
                return NGRFC_INT2;
            }
            case 10: {
                return NGRFC_INT1;
            }
            case 23: {
                return NGRFC_DEC_FLOAT64;
            }
            case 24: {
                return NGRFC_DEC_FLOAT128;
            }
            case 29: {
                return NGRFC_STRING;
            }
            case 30: {
                return NGRFC_XSTRING;
            }
            case 40: 
            case 51: 
            case 52: 
            case 53: {
                return NGRFC_INT8;
            }
            case 99: {
                return NGRFC_TABLE;
            }
            case 17: {
                return NGRFC_STRUCTURE;
            }
        }
        return NGRFC_UNKNOWN;
    }

    public static short getLengthOfNgRfcType(NgRfcType type, boolean isPartnerUnicode) {
        switch (type) {
            case NGRFC_INT1: {
                return 1;
            }
            case NGRFC_INT2: {
                return 2;
            }
            case NGRFC_INT4: {
                return 4;
            }
            case NGRFC_INT8: {
                return 8;
            }
            case NGRFC_DATE1: 
            case NGRFC_DATE2: {
                return (short)(isPartnerUnicode ? 16 : 8);
            }
            case NGRFC_TIME1: 
            case NGRFC_TIME2: {
                return (short)(isPartnerUnicode ? 12 : 6);
            }
            case NGRFC_BIN_FLOAT64: {
                return 8;
            }
            case NGRFC_DEC_FLOAT64: {
                return 8;
            }
            case NGRFC_DEC_FLOAT128: {
                return 16;
            }
            case NGRFC_STRING: 
            case NGRFC_XSTRING: 
            case NGRFC_STRUCTURE: 
            case NGRFC_TABLE: 
            case NGRFC_STRUCTURE_REF: {
                return 64;
            }
        }
        return 0;
    }

    public static boolean typeNeedsLength(NgRfcType ngrfcType) {
        switch (ngrfcType) {
            case NGRFC_CHAR1: 
            case NGRFC_CHAR2: 
            case NGRFC_NUM1: 
            case NGRFC_NUM2: 
            case NGRFC_PBCD: 
            case NGRFC_RAW: {
                return true;
            }
        }
        return false;
    }
}

