/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine.ngrfc.util;

import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.engine.ngrfc.CbRfcException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public final class NgRfcUtil {
    public static final int JCO_SERIALIZATION_PROTOCOL_MIN_VERSION = 2;
    public static final int JCO_SERIALIZATION_PROTOCOL_VERSION_TO_USE = 3;
    public static final int NGRFC_UTF8_FLAG = 32768;
    public static final int NGRFC_TABLE_FLAG = 32768;
    public static final int NGRFC_MD_ALREADY_SENT_FLAG = 8192;
    public static final byte NGRFC_TIME_BITS_COUNT = 17;
    public static final byte BITS_IN_BYTE = 8;
    public static final byte BITS_IN_LL = 64;
    public static final short NGRFC_BUFFER_SIZE = 27994;
    public static final int NGRFC_STRING_BLOCK_SIZE = 65535;
    public static final int NGRFC_XSTRING_BLOCK_SIZE = 65535;
    public static final int NGRFC_MAX_ROW_COUNT_BLOCK_SIZE = 65535;
    public static final int NGRFC_FIRST_CONV_BLOCK_SIZE = 16383;
    public static final int NGRFC_CONV_BLOCK_SIZE = Short.MAX_VALUE;
    public static final int NGRFC_LAST_CONV_BLOCK_FLAG = 32768;
    public static final int NGRFC_SINGLE_CONV_BLOCK_FLAG = 16384;
    public static final short RFC_ABAP_NAME_LENGTH = 30;
    public static final byte NGRFC_SEGMENT_BEGIN = 94;
    public static final byte NGRFC_LAST_SEGMENT_BEGIN = 36;
    public static final byte NGRFC_HEADER = 72;
    public static final byte NGRFC_EXECUTE = 69;
    public static final byte NGRFC_PARAM_WITH_METADATA = 81;
    public static final byte NGRFC_PARAM_DELTA_NO_DATA = 66;
    public static final byte NGRFC_DATA_MD = 68;
    public static final byte NGRFC_PARAM_REQUEST_BY_NAME = 84;
    public static final byte NGRFC_COLUMNS_REQUEST_BY_NAME = 75;
    public static final byte NGRFC_TABLE_DELTA = 65;
    public static final byte NGRFC_TABLE_LINE_DELTA = 70;
    public static final byte NGRFC_COMP_CHAR_SHORT_LIMIT = 4;
    public static final byte NGRFC_COMP_BINARY_LIMIT = 15;
    public static final byte NGRFC_COMP_INT_ROW_NUMBER_LIMIT = 21;
    public static final short NGRFC_COMP_VALUE_COMPRESSION_ENTRY_LIMIT = 255;
    public static final byte NGRFC_COMP_RFC_TABLE = 75;
    public static final byte NGRFC_COMP_VALUE_COMP = 86;
    public static final byte NGRFC_COMP_NO_COMP = 78;
    public static final byte NGRFC_COMP_INITIAL = 73;
    public static final byte NGRFC_COMP_NUM = 77;
    public static final byte NGRFC_COMP_NUM_LENGTH = 71;
    public static final byte NGRFC_COMP_CHAR = 79;
    public static final byte NGRFC_COMP_CHAR_LENGTH = 67;
    public static final byte NGRFC_COMP_INTEGER = 50;
    public static final byte NGRFC_COMP_TIME = 72;
    public static final byte NGRFC_COMP_DATE = 74;
    public static final byte NGRFC_COMP_STRING = 83;
    public static final byte NGRFC_COMP_XSTRING = 88;
    public static final byte NGRFC_COMP_BINARY_LENGTH = 76;
    public static final byte NGRFC_COMP_PACKED_LENGTH = 66;
    private static final char[] nullDateArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    private static final char[] nineDateArray = new char[]{'9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] emptyDateArray = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    public static char[] convertBitsToTime(long ll) {
        char[] value = new char[]{(char)((ll >> 12) / 10L + 48L), (char)((ll >> 12) % 10L + 48L), (char)((ll >> 6 & 0x3FL) / 10L + 48L), (char)((ll >> 6 & 0x3FL) % 10L + 48L), (char)((ll & 0x3FL) / 10L + 48L), (char)((ll & 0x3FL) % 10L + 48L)};
        return value;
    }

    public static long convertTimeToBits(char[] timeValue) {
        if (timeValue.length < 6) {
            return 0L;
        }
        long int8 = 0L;
        int8 |= (long)((timeValue[0] - 48) * 10 + timeValue[1] - 48 << 12);
        int8 |= (long)((timeValue[2] - 48) * 10 + timeValue[3] - 48 << 6);
        return int8 |= (long)((timeValue[4] - 48) * 10 + timeValue[5] - 48);
    }

    public static char[] convertBitsToDate(long ll, int minValue) {
        int y = (int)((ll >> 9) + (long)minValue);
        int m = (int)(ll >> 5 & 0xFL);
        int d = (int)(ll & 0x1FL);
        char[] value = new char[8];
        switch (m) {
            case 13: {
                Arrays.fill(value, ' ');
                break;
            }
            case 14: {
                Arrays.fill(value, '0');
                break;
            }
            case 15: {
                Arrays.fill(value, '9');
                break;
            }
            default: {
                value[0] = (char)(y / 1000 + 48);
                value[1] = (char)(y / 100 % 10 + 48);
                value[2] = (char)(y / 10 % 10 + 48);
                value[3] = (char)(y % 10 + 48);
                value[4] = (char)(m / 10 + 48);
                value[5] = (char)(m % 10 + 48);
                value[6] = (char)(d / 10 + 48);
                value[7] = (char)(d % 10 + 48);
            }
        }
        return value;
    }

    public static long convertDateToBits(String dateValue, long minValue, byte bitCount) {
        long int8 = 0L;
        if (dateValue.startsWith("00000000")) {
            int8 = 448L;
        } else if (dateValue.startsWith("99999999")) {
            int8 = 480L;
        } else if (dateValue.startsWith("        ")) {
            int8 = 416L;
        } else {
            if (bitCount > 9) {
                int8 = (dateValue.charAt(0) - 48) * 1000 + (dateValue.charAt(1) - 48) * 100 + (dateValue.charAt(2) - 48) * 10 + dateValue.charAt(3) - 48;
                int8 = int8 - minValue << 9;
            }
            int8 |= (long)((dateValue.charAt(4) - 48) * 10 + dateValue.charAt(5) - 48 << 5);
            int8 |= (long)((dateValue.charAt(6) - 48) * 10 + dateValue.charAt(7) - 48);
        }
        return int8;
    }

    public static byte getBitCountFromValues(long count) {
        byte bitCount = 0;
        --count;
        while (count > 0L) {
            count >>>= 1;
            bitCount = (byte)(bitCount + 1);
        }
        return bitCount;
    }

    public static byte getBitCountOfIntDiff(long minValue, long maxValue) {
        if (minValue > maxValue) {
            throw new CbRfcException("minValue > maxValue at getBitCountOfIntDiff");
        }
        byte bitCount = 0;
        long diff = maxValue - minValue;
        if (diff < 0L) {
            return NgRfcUtil.getBitCountOfBigIntDiff(BigInteger.valueOf(minValue), BigInteger.valueOf(maxValue));
        }
        while (diff > 0L) {
            diff >>>= 1;
            bitCount = (byte)(bitCount + 1);
        }
        return bitCount;
    }

    private static byte getBitCountOfBigIntDiff(BigInteger minValue, BigInteger maxValue) {
        byte bitCount = 0;
        BigInteger diff = maxValue.subtract(minValue);
        while (diff.compareTo(BigInteger.ZERO) > 0) {
            diff = diff.shiftRight(1);
            bitCount = (byte)(bitCount + 1);
        }
        return bitCount;
    }

    public static long convertYearToInt8(char[] value) {
        return (value[0] - 48) * 1000 + (value[1] - 48) * 100 + (value[2] - 48) * 10 + value[3] - 48;
    }

    public static byte getCompModeForCharColumn(int fieldLength) {
        return fieldLength / 2 < 4 ? (byte)79 : 67;
    }

    public static DefaultRecordMetaData mapFlatToHierarchicalIndex(DefaultRecordMetaData recordMetaData, int flatIndex, ArrayList<Integer> indices) {
        DefaultRecordMetaData currentStruct = recordMetaData;
        int currentIndex = 0;
        if (flatIndex >= currentStruct.getDeepFieldsCount()) {
            throw new CbRfcException("Current index is larger than total number of columns in nested type 1 table");
        }
        indices.clear();
        while (flatIndex >= 0) {
            if (currentStruct.getType(currentIndex) == 17) {
                DefaultRecordMetaData temp = (DefaultRecordMetaData)currentStruct.getRecordMetaData(currentIndex);
                int currentDeepFieldCount = temp.getDeepFieldsCount();
                if (currentDeepFieldCount <= flatIndex) {
                    flatIndex -= currentDeepFieldCount;
                    ++currentIndex;
                    continue;
                }
                indices.add(currentIndex);
                currentStruct = temp;
                currentIndex = 0;
                continue;
            }
            ++currentIndex;
            --flatIndex;
        }
        indices.add(--currentIndex);
        return currentStruct;
    }

    public static boolean containsInvalidDateChars(DefaultTable table, boolean isNestedFlat, int actualIndex, ArrayList<Integer> indices) {
        table.firstRow();
        do {
            char[] date;
            if (Arrays.equals(nullDateArray, date = table.getFieldRecord(isNestedFlat, indices, false).decodeCHAR_AS_ARRAY(actualIndex)) || Arrays.equals(nineDateArray, date) || Arrays.equals(emptyDateArray, date)) continue;
            for (int i = 0; i < 4; ++i) {
                if (date[i] >= '0' && date[i] <= '9') continue;
                return true;
            }
            if (date[4] == '0') {
                if (date[5] < '1' || date[5] > '9') {
                    return true;
                }
            } else if (date[4] == '1') {
                if (date[5] < '0' || date[5] > '2') {
                    return true;
                }
            } else {
                return true;
            }
            if (date[6] < '0' || date[6] > '3') {
                return true;
            }
            if (!(date[6] == '3' ? date[7] != '0' && date[7] != '1' : date[7] < '0' || date[7] > '9')) continue;
            return true;
        } while (table.nextRow());
        return false;
    }

    public static boolean containsInvalidTimeChars(DefaultTable table, boolean isNestedFlat, int actualIndex, ArrayList<Integer> indices) {
        table.firstRow();
        do {
            char[] time;
            if ((time = table.getFieldRecord(isNestedFlat, indices, false).decodeCHAR_AS_ARRAY(actualIndex))[0] < '0' || time[0] > '2') {
                return true;
            }
            if (time[1] < '0' || time[1] > '9') {
                return true;
            }
            if (time[2] < '0' || time[2] > '5') {
                return true;
            }
            if (time[3] < '0' || time[3] > '9') {
                return true;
            }
            if (time[4] < '0' || time[4] > '5') {
                return true;
            }
            if (time[5] >= '0' && time[5] <= '9') continue;
            return true;
        } while (table.nextRow());
        return false;
    }
}

