/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.exceptions;

import com.sap.conn.rfc.api.RfcOptions;

public class RfcInvalidConfigurationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private RfcOptions options;

    public RfcInvalidConfigurationException(String message, RfcOptions params) {
        this(message, params, null);
    }

    public RfcInvalidConfigurationException(String message, RfcOptions params, Throwable cause) {
        super(message, cause);
        this.options = params;
    }

    @Override
    public String getMessage() {
        String destinationName = this.options.getDestination();
        boolean isJRAConfiguration = false;
        if (destinationName.startsWith("JRA") && destinationName.length() > 3) {
            isJRAConfiguration = true;
            for (int i = 3; i < destinationName.length(); ++i) {
                if (Character.isDigit(destinationName.charAt(i))) continue;
                isJRAConfiguration = false;
                break;
            }
        }
        String msg = isJRAConfiguration ? "Configuration of JRA instance used is incorrect: " : "Configuration of destination " + destinationName + " is incorrect: ";
        msg = msg + super.getMessage();
        return msg;
    }
}

