/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.data.RFCSI;
import com.sap.conn.rfc.data.RfcIntParameter;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Calendar;
import java.util.Date;

public final class RfcSystemInfo
implements IRfcFunction {
    private static final String[] documentation = new String[]{"Returns some information about the system environment.", "", "EXPORTING", "  RFCSI_EXPORT   LIKE RFCSI"};

    @Override
    public String getName() {
        return "RFC_SYSTEM_INFO";
    }

    @Override
    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        act_cntl.RfcGetData(null, null, null, null, null);
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        GatewayRegInfo gwRegInfo = RfcApi.runtime.getGatewayRegInfo(act_cntl);
        IRfcParameter[] exp = gwRegInfo == null ? new IRfcParameter[1] : new IRfcParameter[3];
        exp[0] = rfcsi;
        DefaultStructure rfcsiStructure = rfcsi.getStructure();
        rfcsiStructure.setValue(0, new char[]{'0', '1', '1'});
        rfcsiStructure.setValue(1, AbSysInfo.charset);
        if (AbSysInfo.intformat == 1) {
            rfcsiStructure.setValue(2, "LIT");
        } else {
            rfcsiStructure.setValue(2, "BIG");
        }
        rfcsiStructure.setValue(3, new char[]{'I', 'E', '3'});
        rfcsiStructure.setValue(4, AbSysInfo.programName);
        rfcsiStructure.setValue(5, AbSysInfo.host);
        rfcsiStructure.setValue(6, AbSysInfo.systemID);
        rfcsiStructure.setValue(10, "753");
        rfcsiStructure.setValue(12, AbSysInfo.osName);
        rfcsiStructure.setValue(16, AbSysInfo.kernelRelease);
        rfcsiStructure.setValue(17, AbSysInfo.host);
        rfcsiStructure.setValue(15, AbSysInfo.ipAddress);
        if (AbSysInfo.ipv6Address != null) {
            rfcsiStructure.setValue(19, AbSysInfo.ipv6Address);
        }
        Calendar calendar = Calendar.getInstance();
        rfcsiStructure.setValue(13, calendar.get(15) / 1000);
        rfcsiStructure.setValue(14, calendar.getTimeZone().inDaylightTime(new Date()) ? (char)'X' : ' ');
        if (gwRegInfo != null) {
            RfcIntParameter CURRENT_RESOURCES = new RfcIntParameter("CURRENT_RESOURCES");
            exp[1] = CURRENT_RESOURCES;
            CURRENT_RESOURCES.setInt(gwRegInfo.getWaiting());
            RfcIntParameter MAXIMAL_RESOURCES = new RfcIntParameter("MAXIMAL_RESOURCES");
            exp[2] = MAXIMAL_RESOURCES;
            MAXIMAL_RESOURCES.setInt(gwRegInfo.getTotal());
        }
        act_cntl.RfcSendData(exp, null, null);
        act_cntl.flushServerConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultStructure clientExecute(RfcIoOpenCntl act_cntl) throws RfcException {
        boolean isStateless;
        IRfcParameter[] exp = new IRfcParameter[1];
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        exp[0] = rfcsi;
        boolean isClient = act_cntl.rfc_role == 'C';
        boolean bl = isStateless = !act_cntl.isStateful();
        if (isClient && isStateless) {
            act_cntl.setStateful(true);
        }
        try {
            act_cntl.RfcCallReceive("RFC_SYSTEM_INFO", null, exp, null, null, null);
        }
        finally {
            if (isClient && isStateless) {
                act_cntl.setStateful(false);
            }
        }
        return rfcsi.getStructure();
    }

    @Override
    public String[] getDocumentation() {
        return documentation;
    }
}

