/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons;

import com.sap.core.deploy.commons.rest.entity.RestApiVersion;
import com.sap.core.deploy.commons.util.IOUtils;
import org.apache.log4j.Logger;

public class AuditLogger {
    private static final Logger AUDIT_LOGGER = Logger.getLogger((String)"audit.operations");
    private String accessedFrom;
    private String clientIP = "";
    private final String auditMessageHeaderFragment;
    private String restApiVersion;
    private String agentName;
    private String agentVersion;

    public AuditLogger(String xForwardedForHeader, String userPrincipalName, String email, String space, String appliance, String component, RestApiVersion apiVersion) {
        this.accessedFrom = xForwardedForHeader;
        if (userPrincipalName != null) {
            this.accessedFrom = userPrincipalName;
        }
        if (xForwardedForHeader != null) {
            this.clientIP = xForwardedForHeader;
        }
        String jpComponentName = component == null ? "" : component;
        this.auditMessageHeaderFragment = String.valueOf(space) + "#" + appliance + "#" + jpComponentName + "#" + this.clientIP + "#" + email;
        this.restApiVersion = apiVersion.getAuditMessage();
    }

    public AuditLogger(String xForwardedForHeader, String userPrincipalName, String email, String space, String appliance, String component, RestApiVersion apiVersion, String agentName, String agentVersion) {
        this(xForwardedForHeader, userPrincipalName, email, space, appliance, component, apiVersion);
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    public void logAuditDebug(String message) {
        AUDIT_LOGGER.debug((Object)(String.valueOf(this.auditMessageHeaderFragment) + "###" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditDebug(String message, long timemillis) {
        AUDIT_LOGGER.debug((Object)(String.valueOf(this.auditMessageHeaderFragment) + "##" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditDebug(String message, long timemillis, long totalBytesRead) {
        AUDIT_LOGGER.debug((Object)(String.valueOf(this.auditMessageHeaderFragment) + "#" + IOUtils.readableSize(totalBytesRead) + "#" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAudit(String message) {
        AUDIT_LOGGER.info((Object)(String.valueOf(this.auditMessageHeaderFragment) + "###" + message + "##" + this.restApiVersion + "#" + " Agent name: " + this.agentName + "#" + " Agent version: " + this.agentVersion + "#"));
    }

    public void logAudit(String message, String additionalColumn) {
        AUDIT_LOGGER.info((Object)(String.valueOf(this.auditMessageHeaderFragment) + "###" + message + "##" + "#" + additionalColumn + "#" + this.restApiVersion + "#" + " Agent name: " + this.agentName + "#" + " Agent version: " + this.agentVersion + "#"));
    }

    public void logAudit(String message, long timemillis) {
        AUDIT_LOGGER.info((Object)(String.valueOf(this.auditMessageHeaderFragment) + "##" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#" + " Agent name: " + this.agentName + "#" + " Agent version: " + this.agentVersion + "#"));
    }

    public void logAudit(String message, long timemillis, long totalBytesRead) {
        AUDIT_LOGGER.info((Object)(String.valueOf(this.auditMessageHeaderFragment) + "#" + IOUtils.readableSize(totalBytesRead) + "#" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#" + " Agent name: " + this.agentName + "#" + " Agent version: " + this.agentVersion + "#"));
    }

    public void logAuditError(String message) {
        AUDIT_LOGGER.error((Object)(String.valueOf(this.auditMessageHeaderFragment) + "###" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditError(String message, long timemillis) {
        AUDIT_LOGGER.error((Object)(String.valueOf(this.auditMessageHeaderFragment) + "##" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditError(String message, long timemillis, long totalBytesRead) {
        AUDIT_LOGGER.error((Object)(String.valueOf(this.auditMessageHeaderFragment) + "#" + IOUtils.readableSize(totalBytesRead) + "#" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditWarn(String message) {
        AUDIT_LOGGER.warn((Object)(String.valueOf(this.auditMessageHeaderFragment) + "###" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditErrorWarn(String message, long timemillis) {
        AUDIT_LOGGER.warn((Object)(String.valueOf(this.auditMessageHeaderFragment) + "##" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public void logAuditErrorWarn(String message, long timemillis, long totalBytesRead) {
        AUDIT_LOGGER.warn((Object)(String.valueOf(this.auditMessageHeaderFragment) + "#" + IOUtils.readableSize(totalBytesRead) + "#" + String.format("%1$TM:%1$TS", timemillis) + "#" + message + "##" + this.restApiVersion + "#"));
    }

    public static String formatTime(long timemillis) {
        return String.format("%1$TM:%1$TS", timemillis);
    }

    public String getAccessedFrom() {
        return this.accessedFrom;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public boolean isDebugEnabled() {
        return AUDIT_LOGGER.isDebugEnabled();
    }
}

