/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.hotupdate;

public enum Strategy {
    REPLACE_BINARIES("replace-binaries", "1", "redeploys and updates the application binaries"),
    RESTART_RUNTIME("restart-runtime", "2", "redeploys and updates the application binaries and restarts the application process"),
    REPROVISION_RUNTIME("reprovision-runtime", "3", "cleans up the file system, reprovisions the runtime and redeploys and updates the application binaries");

    private String optionName;
    private String index;
    private String description;

    private Strategy(String optionName, String index, String description) {
        this.optionName = optionName;
        this.index = index;
        this.description = description;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getIndex() {
        return this.index;
    }

    public static Strategy fromOptionName(String optionName) {
        Strategy resultStrategy = null;
        Strategy[] strategyArray = Strategy.values();
        int n = strategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Strategy currentStrategy = strategyArray[n2];
            if (currentStrategy.optionName.equals(optionName)) {
                resultStrategy = currentStrategy;
            }
            ++n2;
        }
        return resultStrategy;
    }

    public static Strategy fromIndex(String index) {
        Strategy resultStrategy = null;
        Strategy[] strategyArray = Strategy.values();
        int n = strategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Strategy currentStrategy = strategyArray[n2];
            if (currentStrategy.index.equals(index)) {
                resultStrategy = currentStrategy;
            }
            ++n2;
        }
        return resultStrategy;
    }

    public static String getValues() {
        StringBuilder errorMessage = new StringBuilder(Strategy.values()[0].optionName);
        int i = 1;
        while (i < Strategy.values().length) {
            errorMessage.append("|").append(Strategy.values()[i].optionName);
            ++i;
        }
        return errorMessage.toString();
    }

    public String toString() {
        return String.valueOf(this.optionName) + " - " + this.description;
    }
}

