/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StringFormatLoggerWrapper {
    Logger logger;

    private StringFormatLoggerWrapper(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz);
    }

    public static StringFormatLoggerWrapper getLogger(Class<?> clazz) {
        return new StringFormatLoggerWrapper(clazz);
    }

    private StringFormatLoggerWrapper(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public static StringFormatLoggerWrapper getLogger(String name) {
        return new StringFormatLoggerWrapper(name);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void debug(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format(format, args));
        }
    }

    public void debug(Throwable t, String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format(format, args), t);
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format(format, args));
        }
    }

    public void info(Throwable t, String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format(format, args), t);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)String.format(format, args));
        }
    }

    public void warn(Throwable t, String format, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)String.format(format, args), t);
        }
    }

    public void fatal(String format, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
            this.logger.fatal((Object)String.format(format, args));
        }
    }

    public void fatal(Throwable t, String format, Object ... args) {
        if (this.logger.isEnabledFor((Priority)Level.FATAL)) {
            this.logger.fatal((Object)String.format(format, args), t);
        }
    }

    public void error(String format, Object ... args) {
        this.logger.error((Object)String.format(format, args));
    }

    public void error(Throwable t, String format, Object ... args) {
        this.logger.error((Object)String.format(format, args), t);
    }
}

