/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.protocol;

import com.sap.core.deploy.commons.exception.ProtocolVersionInitializationException;
import com.sap.core.deploy.commons.protocol.api.IVersion;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ProtocolVersion
implements IVersion {
    private static final Logger LOGGER = Logger.getLogger((String)ProtocolVersion.class.getName());
    public static ProtocolVersion EXTERNAL_NAME_FOR_RUNTIME;
    public static ProtocolVersion LIST_RUNTIME_VERSION_LONG;
    public static ProtocolVersion LIST_RUNTIME_ALL;
    public static ProtocolVersion MULTITHREADED;
    public static ProtocolVersion SERVER_VERSION;
    private int major;
    private int minor;
    private static final String SEPARATOR = ".";
    private static final String INVALID_FORMAT_MSG = "Invalid protocol version format: ";

    static {
        try {
            EXTERNAL_NAME_FOR_RUNTIME = new ProtocolVersion("2.2");
            LIST_RUNTIME_VERSION_LONG = new ProtocolVersion("1.25");
            LIST_RUNTIME_ALL = new ProtocolVersion("2.1");
            MULTITHREADED = new ProtocolVersion("2.0");
            SERVER_VERSION = EXTERNAL_NAME_FOR_RUNTIME;
        }
        catch (ProtocolVersionInitializationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ProtocolVersion(int major, int minor) throws ProtocolVersionInitializationException {
        this.major = major;
        this.minor = minor;
        this.validate();
    }

    public ProtocolVersion(String version) throws ProtocolVersionInitializationException {
        if (version == null) {
            throw new NullPointerException("ProtocolVersion is null");
        }
        int maj = 0;
        int min = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR);
            maj = Integer.parseInt(st.nextToken());
            min = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                throw new ProtocolVersionInitializationException(INVALID_FORMAT_MSG + version);
            }
        }
        catch (NoSuchElementException e) {
            throw new ProtocolVersionInitializationException(INVALID_FORMAT_MSG + version, e);
        }
        catch (NumberFormatException e) {
            throw new ProtocolVersionInitializationException(INVALID_FORMAT_MSG + version, e);
        }
        this.major = maj;
        this.minor = min;
        this.validate();
    }

    private void validate() throws ProtocolVersionInitializationException {
        if (this.major < 0) {
            throw new ProtocolVersionInitializationException("Negative major protocol version: " + this.major);
        }
        if (this.minor < 0) {
            throw new ProtocolVersionInitializationException("Negative minor protocol version: " + this.minor);
        }
    }

    @Override
    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        ProtocolVersion other = (ProtocolVersion)object;
        int result = other.major - this.major;
        if (result != 0) {
            return result;
        }
        return other.minor - this.minor;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getVersionString() {
        StringBuilder sb = new StringBuilder().append(this.major).append(SEPARATOR).append(this.minor);
        return sb.toString();
    }

    @Override
    public String toString() {
        return "ProtocolVersion [major=" + this.major + ", minor=" + this.minor + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public int hashCode() {
        return this.major * 13 + this.minor * 23;
    }
}

