/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.protocol;

import com.sap.core.deploy.commons.exception.ProtocolVersionInitializationException;
import com.sap.core.deploy.commons.protocol.ClientCompatibilityMode;
import com.sap.core.deploy.commons.protocol.ProtocolVersion;
import com.sap.core.deploy.commons.protocol.api.IVersion;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;

public class VersionUtil {
    public static final String ACCEPT_HEADER = "Accept";
    public static final String VERSION_KEY = "version";

    public static ClientCompatibilityMode getClientCompatibilityMode(String acceptHeaderValue) throws ProtocolVersionInitializationException {
        IVersion clientVersion = VersionUtil.getProtocolVersion(acceptHeaderValue);
        return VersionUtil.getClientCompatibilityMode(clientVersion);
    }

    public static ClientCompatibilityMode getClientCompatibilityMode(IVersion clientVersion) {
        if (clientVersion == null) {
            return ClientCompatibilityMode.NO_PROTOCOL_VERSION;
        }
        int compareTo = clientVersion.compareTo(ProtocolVersion.SERVER_VERSION);
        ClientCompatibilityMode compatibilityMode = compareTo == 0 ? ClientCompatibilityMode.EQUAL_PROTOCOL_VERSION : (compareTo > 0 ? (clientVersion.getMajor() == ProtocolVersion.SERVER_VERSION.getMajor() ? ClientCompatibilityMode.PREVIOUS_MINOR_PROTOCOL_VERSION : ClientCompatibilityMode.PREVIOUS_MAJOR_PROTOCOL_VERSION) : ClientCompatibilityMode.INCOMPATIBLE_PROTOCOL_VERSION);
        return compatibilityMode;
    }

    public static IVersion getProtocolVersion(String acceptHeaderValue) throws ProtocolVersionInitializationException {
        if (acceptHeaderValue == null || !acceptHeaderValue.contains(VERSION_KEY)) {
            return null;
        }
        BasicHeader acceptHeader = new BasicHeader(ACCEPT_HEADER, acceptHeaderValue);
        HeaderElement[] headerElements = acceptHeader.getElements();
        IVersion foundVersion = null;
        HeaderElement[] headerElementArray = headerElements;
        int n = headerElements.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderElement element = headerElementArray[n2];
            if (element.getParameterCount() == 0) {
                foundVersion = VersionUtil.getVersion(acceptHeaderValue, foundVersion, element.getName(), element.getValue());
            } else {
                NameValuePair[] nameValuePairArray = element.getParameters();
                int n3 = nameValuePairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    NameValuePair pair = nameValuePairArray[n4];
                    foundVersion = VersionUtil.getVersion(acceptHeaderValue, foundVersion, pair.getName(), pair.getValue());
                    ++n4;
                }
            }
            ++n2;
        }
        return foundVersion;
    }

    private static IVersion getVersion(String acceptHeaderValue, IVersion foundVersion, String name, String value) throws ProtocolVersionInitializationException {
        IVersion version = VersionUtil.getVersion(name, value);
        if (version != null) {
            if (foundVersion != null) {
                throw new ProtocolVersionInitializationException("Duplicate \"version\" elements found in HTTP Accept header: " + acceptHeaderValue);
            }
            foundVersion = version;
        }
        return foundVersion;
    }

    private static IVersion getVersion(String key, String versionValue) throws ProtocolVersionInitializationException {
        if (VERSION_KEY.equals(key.trim())) {
            return versionValue == null ? null : new ProtocolVersion(versionValue.trim());
        }
        return null;
    }
}

