/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.entity;

import com.sap.core.deploy.commons.rest.entity.Configuration;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class File {
    protected String path;
    protected long size;
    protected String hash;
    protected String type;
    protected List<Configuration> configuration;

    public File() {
    }

    public File(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("file path is not specified");
        }
        this.path = path;
    }

    public String getPathGuid() {
        try {
            return new String(Base64.encodeBase64((byte[])this.path.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error occurred while processing file with path: " + this.path, e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        boolean isObjectFile = object instanceof File;
        if (!isObjectFile) {
            return false;
        }
        File objectFile = (File)object;
        return this.path.equals(objectFile.path);
    }
}

