/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.entity.request;

import com.sap.core.deploy.commons.rest.entity.PermStorage;
import com.sap.core.deploy.commons.rest.entity.RuntimeArgument;
import com.sap.core.deploy.commons.rest.entity.request.BinariesRequest;
import com.sap.core.deploy.commons.rest.entity.request.RequestEntity;
import com.sap.core.deploy.commons.rest.util.FieldValidator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class ApplicationRequest
extends RequestEntity {
    protected String applicationName;
    protected String runtimeName;
    protected String runtimeVersion;
    protected String applicationUrl;
    protected String maintenanceApplication;
    protected String downtimeApplication;
    protected Integer minProcesses;
    protected Integer maxProcesses;
    protected List<RuntimeArgument> runtimeArguments;
    protected String computeUnitSize;
    protected PermStorage permStorage;
    protected BinariesRequest binaries;
    protected Map<String, String> metadata;
    protected Map<String, String> customProperties;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public void setMaintenanceApplication(String maintenanceApplication) {
        this.maintenanceApplication = maintenanceApplication;
    }

    public void setDowntimeApplication(String downtimeApplication) {
        this.downtimeApplication = downtimeApplication;
    }

    public void setMinProcesses(Integer minProcesses) {
        this.minProcesses = minProcesses;
    }

    public void setMaxProcesses(Integer maxProcesses) {
        this.maxProcesses = maxProcesses;
    }

    public void setRuntimeArguments(List<RuntimeArgument> runtimeArguments) {
        this.runtimeArguments = runtimeArguments;
    }

    public void setComputeUnitSize(String computeUnitSize) {
        this.computeUnitSize = computeUnitSize;
    }

    public void setPermStorage(PermStorage permStorage) {
        this.permStorage = permStorage;
    }

    public void setBinaries(BinariesRequest binaries) {
        this.binaries = binaries;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public Integer getMinProcesses() {
        return this.minProcesses;
    }

    public Integer getMaxProcesses() {
        return this.maxProcesses;
    }

    public List<RuntimeArgument> getRuntimeArguments() {
        return this.runtimeArguments;
    }

    public String getComputeUnitSize() {
        return this.computeUnitSize;
    }

    public PermStorage getPermStorage() {
        return this.permStorage;
    }

    public BinariesRequest getBinaries() {
        return this.binaries;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    @Override
    public void validate() {
        this.validateRequiredFields();
        this.validateAllFields();
    }

    public void validateAllFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.validateField(field);
            ++n2;
        }
        this.validateProcesses();
        this.validateRuntimeArguments();
    }

    private void validateRequiredFields() {
        FieldValidator.getInstance().validate("applicationName", this.applicationName, false);
    }

    private void validateProcesses() {
        FieldValidator.getInstance().validatePositive("minProcesses", this.minProcesses);
        FieldValidator.getInstance().validatePositive("maxProcesses", this.maxProcesses);
        if (this.minProcesses != null && this.maxProcesses != null && this.minProcesses > this.maxProcesses) {
            String errorMessage = String.format("minProcesses <%d> should not be greater than maxProcesses <%d>", this.minProcesses, this.maxProcesses);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void validateRuntimeArguments() {
        if (this.runtimeArguments != null) {
            for (RuntimeArgument runtimeArgument : this.runtimeArguments) {
                FieldValidator.getInstance().validate(runtimeArgument.getKey(), runtimeArgument.getValue());
            }
        }
    }
}

