/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.entity.request;

import com.sap.core.deploy.commons.rest.entity.Configuration;
import com.sap.core.deploy.commons.rest.entity.request.FileEntry;
import com.sap.core.deploy.commons.rest.entity.request.RequestEntity;
import com.sap.core.deploy.commons.rest.util.FieldValidator;
import com.sap.core.deploy.commons.util.IOUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class FileRequest
extends RequestEntity {
    protected String path;
    protected Long size;
    protected String hash;
    protected String type;
    protected List<Configuration> configuration;
    protected List<FileEntry> entries = new ArrayList<FileEntry>();

    public FileRequest() {
    }

    public FileRequest(String path) {
        this();
        this.path = path;
    }

    public String getPathGuid() {
        try {
            return new String(Base64.encodeBase64((byte[])this.path.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error occurred while processing request with file path:" + this.path, e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size should not be negative number");
        }
        this.size = size;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        if (!hash.matches("[a-fA-F0-9]{128}")) {
            throw new IllegalArgumentException("Hash [" + hash + "] is not valid");
        }
        this.hash = hash;
    }

    public List<FileEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FileEntry> entries) {
        this.entries = entries;
    }

    @Override
    public void validate() {
        FieldValidator.getInstance().validateNotEmpty("path", this.path);
        this.checkForPathTraversal();
        FieldValidator.getInstance().validatePositive("size", this.size);
    }

    private void checkForPathTraversal() {
        try {
            IOUtils.createFileSecured(".", this.path);
        }
        catch (IOException iOException) {
            FieldValidator.getInstance().throwValidationException("path", this.path);
        }
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        boolean isObjectFileRequest = object instanceof FileRequest;
        if (!isObjectFileRequest) {
            return false;
        }
        FileRequest fileRequest = (FileRequest)object;
        return this.path.equals(fileRequest.path);
    }

    @Override
    public String toString() {
        return "[path=" + this.path + ", size=" + this.size + ", hash=" + this.hash + ", type=" + this.type + "]";
    }
}

