/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.entity.request;

import com.sap.core.deploy.commons.rest.entity.request.BinariesRequest;
import com.sap.core.deploy.commons.rest.util.FieldValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class RequestEntity {
    private static final Logger logger = Logger.getLogger(RequestEntity.class);

    public abstract void validate();

    protected void validateField(Field field) {
        try {
            String fieldName = field.getName();
            Object fieldValue = this.getFieldValue(field);
            if (fieldValue instanceof String) {
                FieldValidator.getInstance().validate(fieldName, (String)fieldValue);
            } else if (fieldValue instanceof RequestEntity) {
                ((RequestEntity)fieldValue).validate();
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String delimiter = "";
        try {
            Class<?> claz = this.getClass();
            fieldsList.addAll(Arrays.asList(claz.getDeclaredFields()));
            fieldsList.addAll(Arrays.asList(claz.getSuperclass().getDeclaredFields()));
            for (Field field : fieldsList) {
                BinariesRequest binariesRequest;
                String fieldName = field.getName();
                if (fieldName.equals("legacyClient")) continue;
                Object fieldValue = this.getFieldValue(field);
                if (fieldValue != null && !fieldValue.toString().equals("[]")) {
                    sb.append(delimiter);
                    sb.append(String.valueOf(fieldName) + "=" + fieldValue);
                    delimiter = ", ";
                }
                if (field.getType() != BinariesRequest.class || (binariesRequest = (BinariesRequest)fieldValue) == null || binariesRequest.files == null || binariesRequest.files.isEmpty()) continue;
                sb.append("]");
            }
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)"Error while calling method toString()", (Throwable)e);
        }
        sb.append("]");
        return sb.toString();
    }

    protected Object getFieldValue(Field field) throws IllegalAccessException {
        Object fieldValue = null;
        field.setAccessible(true);
        if (!Modifier.isStatic(field.getModifiers())) {
            fieldValue = field.get(this);
            StringBuilder sb = new StringBuilder();
            if (fieldValue != null && field.getType() == List.class) {
                String delimiter = "";
                StringTokenizer stringTokenizer = new StringTokenizer(fieldValue.toString(), ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String nextToken = stringTokenizer.nextToken();
                    if (nextToken.contains("=null") || nextToken.contains("='null'") || nextToken.contains("=\"null\"")) continue;
                    sb.append(delimiter);
                    sb.append(nextToken);
                    delimiter = ",";
                }
                fieldValue = sb.toString();
                if (!fieldValue.toString().startsWith("[")) {
                    fieldValue = "[" + fieldValue;
                }
                if (!fieldValue.toString().endsWith("]")) {
                    fieldValue = String.valueOf(fieldValue) + "]";
                }
            }
        }
        field.setAccessible(false);
        return fieldValue;
    }
}

