/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.entity.response;

import com.sap.core.deploy.commons.rest.entity.enumerations.FileStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.FileResponseEntry;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class FileResponse
implements Serializable {
    private static final long serialVersionUID = -2406964090303639977L;
    protected String path;
    private String pathGuid;
    protected Long size;
    protected FileStateEnum status;
    protected String hash;
    protected List<FileResponseEntry> entries;

    public FileResponse() {
    }

    public FileResponse(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("file path is not specified");
        }
        this.path = path;
        try {
            this.pathGuid = new String(Base64.encodeBase64((byte[])path.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error occurred while processing response with file path:" + path, e);
        }
    }

    public FileResponse(String path, Long size, String hash) {
        this(path);
        this.size = size;
        this.hash = hash;
    }

    public String getPathGuid() {
        return this.pathGuid;
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public FileStateEnum getStatus() {
        return this.status;
    }

    public void setStatus(FileStateEnum status) {
        this.status = status;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public List<FileResponseEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<FileResponseEntry> entries) {
        this.entries = entries;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        boolean isObjectFile = object instanceof FileResponse;
        if (!isObjectFile) {
            return false;
        }
        FileResponse objectFile = (FileResponse)object;
        return this.path.equals(objectFile.path);
    }
}

