/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.util;

import java.util.Hashtable;

public final class FieldPatterns {
    private static FieldPatterns INSTANCE = new FieldPatterns();
    private Hashtable<String, String> patterns = new Hashtable();

    public static FieldPatterns getInstance() {
        return INSTANCE;
    }

    private FieldPatterns() {
        this.initPatterns();
    }

    private void initPatterns() {
        this.patterns.put("applicationName", "^[A-Za-z]+[A-Za-z0-9]*$");
        this.patterns.put("compression", "^on$|^off$|^force$|^[\\d]*$");
        this.patterns.put("compressibleMimeTypes", "^[^<>\\*]+/[^<>\\*]+$");
        this.patterns.put("compressionMinSize", "^[\\d]*$");
        this.patterns.put("maxThreads", "^[\\d]*$");
        this.patterns.put("connectionTimeout", "^-1$|^[\\d]*$");
        this.patterns.put("runtimeName", "^[A-Za-z]+[-A-Za-z0-9]*$");
        this.patterns.put("runtimeVersion", "[0-9]+(.[0-9]+){0,2}");
        this.patterns.put("jvmVersion", "(([6-8])|([1](.[3-8])))(.[0-9]+){0,2}");
        this.patterns.put("minProcesses", "^[\\d]+$");
        this.patterns.put("maxProcesses", "^[\\d]+$");
        this.patterns.put("computeUnitSize", "^LITE$|^PRO$|^PREMIUM$|^PREMIUM_PLUS$");
    }

    public String getPattern(String field) {
        return this.patterns.get(field);
    }
}

