/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.rest.util;

import com.sap.core.deploy.commons.rest.util.FieldPatterns;

public class FieldValidator {
    private static FieldValidator INSTANCE = new FieldValidator();

    public static FieldValidator getInstance() {
        return INSTANCE;
    }

    private FieldValidator() {
    }

    public void validate(String name, String value) {
        this.validate(name, value, true);
    }

    public void validate(String fieldName, String value, boolean acceptNulls) {
        String pattern = FieldPatterns.getInstance().getPattern(fieldName);
        if (!acceptNulls) {
            this.validateNotEmpty(fieldName, value);
        }
        if (value != null && pattern != null && !value.matches(pattern)) {
            this.throwValidationException(fieldName, value);
        }
    }

    public void validateNotEmpty(String fieldName, String value) {
        if (value == null || value.trim().length() == 0) {
            this.throwValidationException(fieldName, value);
        }
    }

    public void validatePositive(String fieldName, Number value) {
        if (value != null && value.longValue() <= 0L) {
            this.throwValidationException(fieldName, value);
        }
    }

    public void throwValidationException(String fieldName, Object value) {
        throw new IllegalArgumentException(String.valueOf(fieldName) + " contains invalid value <" + value + ">");
    }
}

