/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.retry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodReflectionFinder {
    public static final String METHOD_NOT_FOUND_MSG_PLACEHOLDER = "Method [%s] not found! Check method signiture. ";
    public static final String METHOD_AMBIGUOUS_CALL_PLACEHOLDER = "Method [%s] not found! Check method signiture. Ambiguous arguments provided!";

    public static Method getWantedMethod(Object classInstance, String methodName, Object ... params) throws IllegalAccessException, NoSuchMethodException {
        List<Method> filteredMethods = MethodReflectionFinder.filterByMethodName(classInstance, methodName);
        filteredMethods = MethodReflectionFinder.filterByMethodArgumentsCount(filteredMethods, params.length);
        if ((filteredMethods = MethodReflectionFinder.filterByMethodArgumentsClasses(filteredMethods, params)).isEmpty()) {
            throw new NoSuchMethodException(String.format(METHOD_NOT_FOUND_MSG_PLACEHOLDER, methodName));
        }
        if ((filteredMethods = MethodReflectionFinder.filterByMethodArgumentClassesHierarchy(filteredMethods, params)).size() != 1) {
            throw new NoSuchMethodException(String.format(METHOD_AMBIGUOUS_CALL_PLACEHOLDER, methodName));
        }
        return filteredMethods.get(0);
    }

    protected static List<Method> filterByMethodArgumentClassesHierarchy(List<Method> methodsToFilter, Object[] params) throws IllegalAccessException {
        if (methodsToFilter.size() == 1) {
            return methodsToFilter;
        }
        Class<?>[] desiredParametersTypes = MethodReflectionFinder.obtainInitializedParametersClasses(params);
        ArrayList<HashSet<Method>> bestMatchingMethodsForParam = new ArrayList<HashSet<Method>>(params.length);
        int i = 0;
        while (i < params.length) {
            HashSet<Method> methodsWithMinDelta = new HashSet<Method>();
            int minDelta = Integer.MAX_VALUE;
            for (Method method : methodsToFilter) {
                Class<?>[] declaredParameterTypes = method.getParameterTypes();
                if (desiredParametersTypes[i] != null) {
                    int delta = MethodReflectionFinder.findDelta(desiredParametersTypes[i], declaredParameterTypes[i]);
                    if (delta < minDelta) {
                        minDelta = delta;
                        methodsWithMinDelta.clear();
                        methodsWithMinDelta.add(method);
                        continue;
                    }
                    if (delta != minDelta) continue;
                    methodsWithMinDelta.add(method);
                    continue;
                }
                methodsWithMinDelta.add(method);
            }
            bestMatchingMethodsForParam.add(methodsWithMinDelta);
            ++i;
        }
        Set<Method> intersection = MethodReflectionFinder.findIntersection(bestMatchingMethodsForParam);
        return new ArrayList<Method>(intersection);
    }

    private static Set<Method> findIntersection(List<HashSet<Method>> bestMatchingMethodsForParam) {
        HashSet<Method> intersection = new HashSet();
        intersection = bestMatchingMethodsForParam.get(0);
        if (bestMatchingMethodsForParam.size() > 1) {
            int i = 1;
            while (i < bestMatchingMethodsForParam.size()) {
                if (intersection.size() == 0) {
                    return intersection;
                }
                intersection.retainAll((Collection)bestMatchingMethodsForParam.get(i));
                ++i;
            }
        }
        return intersection;
    }

    protected static int findDelta(Class<?> class1, Class<?> class2) {
        int delta = 0;
        if (class1.equals(class2)) {
            return 0;
        }
        Class<?> parentClass = class1;
        Class<?> childClass = class2;
        if (class2.isAssignableFrom(class1)) {
            parentClass = class2;
            childClass = class1;
        }
        while (!childClass.equals(parentClass)) {
            childClass = childClass.getSuperclass();
            ++delta;
        }
        return delta;
    }

    private static List<Method> filterByMethodArgumentsClasses(List<Method> methodsToFilter, Object[] params) throws IllegalAccessException {
        if (methodsToFilter.isEmpty()) {
            return methodsToFilter;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        Class<?>[] desiredParametersTypes = MethodReflectionFinder.obtainInitializedParametersClasses(params);
        int i = 0;
        while (i < methodsToFilter.size()) {
            Class<?>[] parameterTypes = methodsToFilter.get(i).getParameterTypes();
            if (MethodReflectionFinder.areParametersClassesEqualOrInHierarchy(desiredParametersTypes, parameterTypes)) {
                result.add(methodsToFilter.get(i));
            }
            ++i;
        }
        return result;
    }

    private static boolean areParametersClassesEqualOrInHierarchy(Class<?>[] desiredParametersTypes, Class<?>[] parameterTypes) {
        int i = 0;
        while (i < desiredParametersTypes.length) {
            if (desiredParametersTypes[i] != null && !parameterTypes[i].isAssignableFrom(desiredParametersTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static List<Method> filterByMethodArgumentsCount(List<Method> methodsToFilter, int desiredLenght) {
        if (methodsToFilter.isEmpty()) {
            return methodsToFilter;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        int i = 0;
        while (i < methodsToFilter.size()) {
            if (MethodReflectionFinder.getMethodParametersCount(methodsToFilter.get(i)) == desiredLenght) {
                result.add(methodsToFilter.get(i));
            }
            ++i;
        }
        return result;
    }

    private static int getMethodParametersCount(Method method) {
        return method.getParameterTypes().length;
    }

    private static List<Method> filterByMethodName(Object classInstance, String methodName) {
        Method[] classMethods = classInstance.getClass().getDeclaredMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = classMethods;
        int n = classMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                result.add(method);
            }
            ++n2;
        }
        return result;
    }

    private static Class<?>[] obtainInitializedParametersClasses(Object ... params) throws IllegalAccessException {
        Class[] paramsClasses = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            paramsClasses[i] = MethodReflectionFinder.getClassOrTypeForObject(params[i]);
            ++i;
        }
        return paramsClasses;
    }

    private static Class<?> getClassOrTypeForObject(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        Class clazz = obj.getClass();
        try {
            clazz = (Class)clazz.getField("TYPE").get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return clazz;
    }
}

