/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.retry;

import com.sap.core.deploy.commons.retry.MethodReflectionFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.log4j.Logger;

public class RetryPerformer {
    private static final Logger LOGGER = Logger.getLogger(RetryPerformer.class);
    public static final String RETRY_LOGIC_FAILED_MSG = "Retry logic failed. ";
    public static final int DEFAULT_SLEEP_TIMEOUT_BETWEEN_RETRIES = 5000;
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private Set<String> retryableExceptionMessages;
    private int maxRetryCount;
    private boolean useBackOffStrategy;
    private int sleepTimeoutBetweenRetries;

    public RetryPerformer(Set<String> retryableExceptionMessages) {
        this.maxRetryCount = 3;
        this.sleepTimeoutBetweenRetries = 5000;
        this.useBackOffStrategy = true;
        this.retryableExceptionMessages = retryableExceptionMessages;
    }

    public RetryPerformer(int maxRetryCount, int sleepTimeoutBetweenRetries, boolean useBackOffStrategy, Set<String> retryableExceptionMessages) {
        if (maxRetryCount <= 0) {
            throw new IllegalArgumentException("Invalid value for max retry count - only positive values are accepted.");
        }
        this.maxRetryCount = maxRetryCount;
        if (sleepTimeoutBetweenRetries < 0) {
            throw new IllegalArgumentException("Invalid value for sleep timeout between retries - only non negative values are accepted.");
        }
        this.sleepTimeoutBetweenRetries = sleepTimeoutBetweenRetries;
        this.useBackOffStrategy = useBackOffStrategy;
        this.retryableExceptionMessages = retryableExceptionMessages;
    }

    public Object retry(Object classInstance, String methodName, Object ... params) throws Exception {
        return this.retry(this.maxRetryCount, classInstance, MethodReflectionFinder.getWantedMethod(classInstance, methodName, params), params);
    }

    public Object retry(int maxNumberOfRetries, Object classInstance, Method method, Object ... params) throws Exception {
        boolean shouldRetry = true;
        int currentRetryCount = 1;
        while (shouldRetry) {
            try {
                return this.invokeRealMethod(classInstance, method, params);
            }
            catch (Exception e) {
                shouldRetry = this.checkIfShouldRetry(++currentRetryCount, maxNumberOfRetries, e, method.getName());
                if (shouldRetry) continue;
                this.throwExceptionRetriesFailed(e);
            }
        }
        return null;
    }

    protected Object invokeRealMethod(Object classInstance, Method method, Object ... params) throws Exception {
        try {
            return method.invoke(classInstance, params);
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getCause();
        }
    }

    protected boolean checkIfShouldRetry(int currentRetryCount, int numberOfRetries, Exception exception, String methodName) throws InterruptedException {
        boolean isExceptionExceptable = this.checkIfShouldRetryAfterException(exception);
        if (!isExceptionExceptable) {
            return isExceptionExceptable;
        }
        if (currentRetryCount <= numberOfRetries) {
            LOGGER.error((Object)String.format("Error occured while executing method [%s]. Exception type is [%s] and message [%s]. Starting attempt #%d of %d.", methodName, exception.getClass(), exception.getMessage(), currentRetryCount, numberOfRetries));
            Thread.sleep(this.calculateSleepTimeBetweenRetries(currentRetryCount));
            return true;
        }
        LOGGER.error((Object)String.format("Execution of method [%s] failed [%s] times. No more retries will be attempted.", methodName, numberOfRetries));
        return false;
    }

    protected void throwExceptionRetriesFailed(Exception e) throws Exception {
        Throwable cause;
        String exceptionMessage = RETRY_LOGIC_FAILED_MSG;
        if (e.getMessage() != null) {
            exceptionMessage = String.valueOf(exceptionMessage) + "Causing exception message is : ";
            exceptionMessage = String.valueOf(exceptionMessage) + e.getMessage();
        }
        if ((cause = e.getCause()) != null) {
            throw (Exception)cause.getClass().getConstructor(String.class).newInstance(exceptionMessage);
        }
        throw (Exception)e.getClass().getConstructor(String.class).newInstance(exceptionMessage);
    }

    protected boolean checkIfShouldRetryAfterException(Exception exception) {
        String message = exception.toString();
        boolean matchFound = false;
        if (message == null) {
            return false;
        }
        for (String retryableExceptionMessage : this.retryableExceptionMessages) {
            if (!message.contains(retryableExceptionMessage)) continue;
            matchFound = true;
        }
        return matchFound;
    }

    private int calculateSleepTimeBetweenRetries(int currentRetryCount) {
        if (this.useBackOffStrategy) {
            return this.sleepTimeoutBetweenRetries * currentRetryCount;
        }
        return this.sleepTimeoutBetweenRetries;
    }
}

