/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.runtime;

import com.google.gson.annotations.Expose;
import com.sap.core.deploy.commons.runtime.Version;
import java.util.Collection;

public class RuntimeVersions {
    public static final String ALL_VERSIONS = "all";
    public static final String RUNTIME_ID = "runtimeId";
    public static final String VERSION_RESOURCES = "versionResources";
    public static final String UNKNOWN = "unknown";
    public static final String RUNTIME_ID_KEY = "id";
    public static final String RUNTIME_DISPLAY_NAME_KEY = "displayName";
    public static final String RUNTIME_VERSION_KEY = "version";
    public static final String RUNTIME_EXPIRATION_DATE_KEY = "expDate";
    public static final String RUNTIME_RELEASE_DATE_KEY = "relDate";
    public static final String RUNTIME_STATE_KEY = "state";
    public static final String RUNTIME_STATE_RECOMMENDED = "recommended";
    public static final String RUNTIME_STATE_DEPRECATED = "deprecated";
    public static final String RUNTIME_STATE_EXPIRED = "expired";
    public static final String MESSAGE_KEY = "message";
    @Expose
    private String runtimeId;
    @Expose
    private String displayName;
    @Expose
    private Collection<Version> versionResources;

    public RuntimeVersions() {
    }

    public RuntimeVersions(String runtimeId, String displayName, Collection<Version> versionResources) {
        this.runtimeId = runtimeId;
        this.displayName = displayName;
        this.versionResources = versionResources;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public void setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Collection<Version> getVersionResources() {
        return this.versionResources;
    }

    public void setVersionResources(Collection<Version> versionResources) {
        this.versionResources = versionResources;
    }

    public Version getVersion(String versionAsString) {
        block5: {
            String[] versionDigits;
            block4: {
                if (versionAsString == null) {
                    return null;
                }
                if (versionAsString.isEmpty()) {
                    return null;
                }
                versionDigits = versionAsString.split("\\.");
                if (versionDigits.length != 3) break block4;
                for (Version version : this.versionResources) {
                    if (!versionAsString.equals(version.getVersionString())) continue;
                    return version;
                }
                break block5;
            }
            if (versionDigits.length != 2) break block5;
            for (Version version : this.versionResources) {
                if (!versionAsString.equals(version.getMajorMinorVersionString())) continue;
                int latestMicroVersion = this.getLatestMicroVersion(versionAsString, version.getMicro());
                String versionToLatestMicroAsString = String.valueOf(versionAsString) + "." + String.valueOf(latestMicroVersion);
                return this.getVersion(versionToLatestMicroAsString);
            }
        }
        return null;
    }

    public String toString() {
        return "RuntimeVersionsResource [runtimeId=" + this.runtimeId + ", displayName=" + this.displayName + ", versionResources=" + this.versionResources + "]";
    }

    private int getLatestMicroVersion(String versionAsString, int microVersion) {
        for (Version v : this.versionResources) {
            if (!versionAsString.equals(v.getMajorMinorVersionString()) || v.getMicro() <= microVersion) continue;
            microVersion = v.getMicro();
        }
        return microVersion;
    }
}

