/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.runtime;

import com.google.gson.annotations.Expose;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Version
implements Comparable {
    public static final String MAJOR = "major";
    public static final String MINOR = "minor";
    public static final String MICRO = "micro";
    public static final String HOTFIX = "hotfix";
    public static final String DEFAULT_ = "default_";
    public static final String BETA = "beta";
    public static final String DEPRECATED = "deprecated";
    public static final String BROKEN = "broken";
    public static final String VERSION_TYPE = "versionType";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String RELEASE_DATE = "releaseDate";
    public static final String SAP_JVM_VERSIONS = "sapJvmVersions";
    protected static final String VERSION_SEPARATOR = ".";
    protected static final String VERSION_TYPE_SEPARATOR = ";";
    private static final String DEFAULT = "default";
    private static final String EXP_DATE = "exp";
    private static final String REL_DATE = "rel";
    private static final DateFormat rvDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    private static final Logger LOGGER = Logger.getLogger(Version.class);
    @Expose
    private int major;
    @Expose
    private int minor;
    @Expose
    private int micro;
    @Expose
    private int hotfix;
    @Expose
    private boolean beta;
    @Expose
    private boolean default_;
    @Expose
    private boolean deprecated;
    @Expose
    private boolean broken;
    @Expose
    private String versionType;
    @Expose
    private Calendar expirationDate;
    @Expose
    private Calendar releaseDate;
    @Expose
    private Map<String, String> sapJvmVersions;

    public Version() {
    }

    public Version(String version, String versionType) {
        int maj = 0;
        int min = 0;
        int mic = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, VERSION_SEPARATOR);
            maj = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                mic = Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format.", e);
        }
        this.major = maj;
        this.minor = min;
        this.micro = mic;
        this.hotfix = 0;
        this.parseVersionType(versionType);
        this.versionType = this.excludeExpAndRelDatesFromVersionType(versionType);
        this.validate();
    }

    protected void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro");
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Version other = (Version)object;
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        return this.micro - other.micro;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public String getVersionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(VERSION_SEPARATOR).append(this.minor).append(VERSION_SEPARATOR).append(this.micro);
        return sb.toString();
    }

    public String getMajorMinorVersionString() {
        StringBuilder sb = new StringBuilder().append(this.major).append(VERSION_SEPARATOR).append(this.minor);
        return sb.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getHotfix() {
        return this.hotfix;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public boolean isDefault() {
        return this.default_;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public Calendar getReleaseDate() {
        return this.releaseDate;
    }

    public boolean isDefault_() {
        return this.default_;
    }

    public void setDefault_(boolean default_) {
        this.default_ = default_;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public void setHotfix(int hotfix) {
        this.hotfix = hotfix;
    }

    public void setBeta(boolean beta) {
        this.beta = beta;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public void setVersionType(String versionType) {
        this.versionType = versionType;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setReleaseDate(Calendar releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String toString() {
        return "Version [major=" + this.major + ", minor=" + this.minor + ", micro=" + this.micro + ", " + "beta=" + this.beta + ", default_=" + this.default_ + ", deprecated=" + this.deprecated + ", broken=" + this.broken + ", " + "expirationDate=" + this.expirationDate + ", releaseDate=" + this.releaseDate + "]";
    }

    private void parseVersionType(String runtimeVersionInfo) {
        String[] rvProperties;
        String[] stringArray = rvProperties = runtimeVersionInfo.split(VERSION_TYPE_SEPARATOR);
        int n = rvProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String rvProperty = stringArray[n2];
            if (rvProperty.equals(BETA)) {
                this.beta = true;
            } else if (rvProperty.equals(DEFAULT)) {
                this.default_ = true;
            } else if (rvProperty.equals(DEPRECATED)) {
                this.deprecated = true;
            } else if (rvProperty.equals(BROKEN)) {
                this.broken = true;
            } else if (rvProperty.startsWith(EXP_DATE)) {
                this.expirationDate = this.readDateFromRuntimeVersionInfo(EXP_DATE, rvProperty, "runtime expiration date", runtimeVersionInfo);
            } else if (rvProperty.startsWith(REL_DATE)) {
                this.releaseDate = this.readDateFromRuntimeVersionInfo(REL_DATE, rvProperty, "runtime release date", runtimeVersionInfo);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar readDateFromRuntimeVersionInfo(String dateType, String dateField, String dateFieldHumanReadableName, String runtimeVersionInfo) {
        String dateAsString = dateField.substring(dateType.length());
        Date date = null;
        Calendar result = null;
        try {
            DateFormat dateFormat = rvDateFormat;
            synchronized (dateFormat) {
                date = rvDateFormat.parse(dateAsString);
            }
            result = Calendar.getInstance(Locale.ENGLISH);
            result.setTime(date);
        }
        catch (Exception e) {
            this.logMessageWhenParsing(dateFieldHumanReadableName, dateAsString, runtimeVersionInfo, e);
        }
        return result;
    }

    private void logMessageWhenParsing(String fieldType, String fieldValue, String runtimeVersionInfo, Exception e) {
        LOGGER.warn((Object)String.format("Error parsing %s from string [%s], extracted from runtime version info string [%s].\nThis error will not stop the execution of the current operation", fieldType, fieldValue, runtimeVersionInfo), (Throwable)e);
    }

    private String excludeExpAndRelDatesFromVersionType(String versionType) {
        String[] versionTypes;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = versionTypes = versionType.split(VERSION_TYPE_SEPARATOR);
        int n = versionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String versionTypeElement = stringArray[n2];
            if (versionTypeElement.equals(BETA) || versionTypeElement.equals(DEFAULT) || versionTypeElement.equals(DEPRECATED)) {
                sb.append(versionTypeElement).append(VERSION_TYPE_SEPARATOR);
            }
            ++n2;
        }
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean isPastExpirationDate() {
        boolean iPastExpirationDate;
        if (this.expirationDate == null) {
            return false;
        }
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        boolean bl = iPastExpirationDate = !this.expirationDate.after(yesterday);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking if runtime version " + this.toString() + " is past expiration date. Expiration date: " + this.expirationDate.getTime() + "; yesterday's date: " + yesterday.getTime() + ". Is past expiration date: " + iPastExpirationDate));
        }
        return iPastExpirationDate;
    }

    public boolean isRecommended() {
        if (this.isPastExpirationDate()) {
            return false;
        }
        if (this.releaseDate == null || this.default_) {
            return true;
        }
        Calendar yesterdayThreeMonthsAgo = Calendar.getInstance();
        yesterdayThreeMonthsAgo.add(5, -1);
        yesterdayThreeMonthsAgo.add(2, -3);
        return this.releaseDate.after(yesterdayThreeMonthsAgo);
    }

    public void setSapJvmVersions(Map<String, String> sapJvmVersions) {
        this.sapJvmVersions = sapJvmVersions;
    }

    public Map<String, String> getSapJvmVersions() {
        return this.sapJvmVersions;
    }
}

