/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.runtime.map;

import com.sap.core.deploy.commons.exception.RuntimeVersionInitializationException;
import com.sap.core.deploy.commons.runtime.map.ExternalRuntimeMetadata;
import java.util.ArrayList;
import java.util.List;

public class Mapping {
    private ExternalRuntimeMetadata[] mapping;

    public List<ExternalRuntimeMetadata> getExternalRuntimesByExternalId(String externalId) {
        ArrayList<ExternalRuntimeMetadata> result = new ArrayList<ExternalRuntimeMetadata>();
        if (this.mapping != null) {
            ExternalRuntimeMetadata[] externalRuntimeMetadataArray = this.mapping;
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalRuntimeMetadata mappedRuntime = externalRuntimeMetadataArray[n2];
                if (mappedRuntime.getName().equals(externalId)) {
                    result.add(mappedRuntime);
                }
                ++n2;
            }
        }
        return result;
    }

    public List<ExternalRuntimeMetadata> getExternalRuntimesByInternalId(String internalId) {
        ArrayList<ExternalRuntimeMetadata> result = new ArrayList<ExternalRuntimeMetadata>();
        if (this.mapping != null) {
            ExternalRuntimeMetadata[] externalRuntimeMetadataArray = this.mapping;
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalRuntimeMetadata mappedRuntime = externalRuntimeMetadataArray[n2];
                if (mappedRuntime.getMapped_runtime().getName().equals(internalId)) {
                    result.add(mappedRuntime);
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean isExternalId(String runtimeId) {
        return !this.getExternalRuntimesByExternalId(runtimeId).isEmpty();
    }

    public ExternalRuntimeMetadata getExternalRuntimeByInternalId(String internalId, String internalVersion) {
        if (this.mapping != null) {
            ExternalRuntimeMetadata[] externalRuntimeMetadataArray = this.mapping;
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalRuntimeMetadata mappedRuntime = externalRuntimeMetadataArray[n2];
                if (mappedRuntime.getMapped_runtime().getName().equals(internalId) && mappedRuntime.getMapped_runtime().getVersion().equals(internalVersion)) {
                    return mappedRuntime;
                }
                ++n2;
            }
        }
        return null;
    }

    public ExternalRuntimeMetadata getExternalRuntimeByExternalId(String externalId, String externalVersion) throws RuntimeVersionInitializationException {
        ExternalRuntimeMetadata result = null;
        if (this.mapping != null) {
            ExternalRuntimeMetadata[] externalRuntimeMetadataArray = this.mapping;
            int n = this.mapping.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalRuntimeMetadata mappedRuntime = externalRuntimeMetadataArray[n2];
                if (mappedRuntime.getName().equals(externalId) && mappedRuntime.getVersion().equals(externalVersion)) {
                    result = mappedRuntime;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public String toString() {
        if (this.mapping == null || this.mapping.length == 0) {
            return "Empty runtimes map";
        }
        StringBuilder result = new StringBuilder();
        ExternalRuntimeMetadata[] externalRuntimeMetadataArray = this.mapping;
        int n = this.mapping.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalRuntimeMetadata mappedRuntime = externalRuntimeMetadataArray[n2];
            result.append(mappedRuntime == null ? "null" : mappedRuntime.getName()).append("_");
            result.append(mappedRuntime == null ? "null" : mappedRuntime.getVersion()).append(" = ");
            result.append(mappedRuntime == null ? "null" : mappedRuntime.getMapped_runtime().getName()).append("_");
            result.append(mappedRuntime == null ? "null" : mappedRuntime.getMapped_runtime().getVersion()).append("\r\n");
            ++n2;
        }
        return result.toString();
    }
}

