/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.rest.entity.enumerations.FileStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.FileEntry;
import com.sap.core.deploy.commons.rest.entity.request.FileRequest;
import com.sap.core.deploy.commons.rest.entity.request.FileResponseEntry;
import com.sap.core.deploy.commons.rest.entity.response.BinariesResponse;
import com.sap.core.deploy.commons.rest.entity.response.FileResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BinariesJsonUtil {
    protected static final Logger LOGGER = Logger.getLogger((String)BinariesJsonUtil.class.getName());
    public static final String DEPLOYED_STATUS = "DEPLOYED";

    public BinariesResponse createBinariesResponse(Map<String, FileRequest> fileRequestsMap) {
        return this.createBinariesResponse(fileRequestsMap, DEPLOYED_STATUS);
    }

    private BinariesResponse createBinariesResponse(Map<String, FileRequest> fileRequestsMap, String status) {
        BinariesResponse binariesResponse = new BinariesResponse();
        binariesResponse.setFiles(this.getFileResponse(fileRequestsMap.values()));
        binariesResponse.setStatus(status);
        binariesResponse.setTotalSize(this.getTotalSize(binariesResponse.getFiles()));
        this.logDebug("Cretated binaries response: %s", binariesResponse);
        return binariesResponse;
    }

    private Long getTotalSize(List<FileResponse> files) {
        Long totalSize = 0L;
        for (FileResponse fileResponse : files) {
            totalSize = totalSize + fileResponse.getSize();
        }
        return totalSize;
    }

    private List<FileResponse> getFileResponse(Collection<FileRequest> values) {
        ArrayList<FileResponse> files = new ArrayList<FileResponse>();
        for (FileRequest fileRequest : values) {
            FileResponse fileResponse = new FileResponse(fileRequest.getPath(), fileRequest.getSize(), fileRequest.getHash());
            fileResponse.setStatus(FileStateEnum.AVAILABLE);
            fileResponse.setEntries(this.getResponseEntries(fileRequest));
            files.add(fileResponse);
            this.logDebug("Add file response to list: %s", fileResponse);
        }
        return files;
    }

    private List<FileResponseEntry> getResponseEntries(FileRequest fileRequest) {
        ArrayList<FileResponseEntry> responseEntries = new ArrayList<FileResponseEntry>();
        for (FileEntry requestEntry : fileRequest.getEntries()) {
            responseEntries.add(new FileResponseEntry(requestEntry.getPath(), requestEntry.getSize(), requestEntry.getHash()));
        }
        this.logDebug("Getting response entries: %s by file request: %s", responseEntries, fileRequest);
        return responseEntries;
    }

    private void logDebug(String format, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(format, args));
        }
    }
}

