/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.exception.DeployServiceException;
import java.io.File;
import java.io.FileFilter;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DeploymentUtils {
    private static final Logger LOGGER = Logger.getLogger(DeploymentUtils.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HINT = "The server may not have enough disk space or the server process has no permissions to write on the file system.";
    public static final String EXCEPTION_MESSAGE_CREATING_FOLDER = "Cannot create a work directory [%1$s] to perform operations." + LINE_SEPARATOR + "The server may not have enough disk space or the server process has no permissions to write on the file system.";
    public static final String EXCEPTION_MESSAGE_MALICIOUS_FILE_NAME = "Malicious file name [%1$s] detected";
    private static final String LOGGING_ERROR_CREATING_FOLDER = "Cannot create a work directory [%1$s] with user [" + System.getProperty("user.name") + "] to perform operations." + LINE_SEPARATOR + "The server may not have enough disk space or the server process has no permissions to write on the file system.";
    private static final int MAX_CREATE_ATTEMPTS = 10;
    public static final String PREFIX = "jpaas.server.";
    public static File DEPLOY_TEMP_DIR = new File(System.getProperty("deploy.tmpdir", "/usr/sap/tmpdeploy"));

    public File createTempDirectory_NonStaticCall() throws DeployServiceException {
        return DeploymentUtils.createTempDirectory();
    }

    public static File createTempDirectory() throws DeployServiceException {
        return DeploymentUtils.createTempDirectory(DEPLOY_TEMP_DIR);
    }

    public File createTempDirectory_NonStaticCall(File parentTempDir) throws DeployServiceException {
        return DeploymentUtils.createTempDirectory(parentTempDir);
    }

    public static File createTempDirectory(File parentTempDir) throws DeployServiceException {
        File tmpDir;
        int attempts = 0;
        do {
            if (++attempts <= 10) continue;
            String attemptsString = "after 10 attempts";
            LOGGER.error((Object)String.format(LOGGING_ERROR_CREATING_FOLDER, "in " + parentTempDir.getAbsolutePath() + " " + attemptsString));
            throw new DeployServiceException(String.format(EXCEPTION_MESSAGE_CREATING_FOLDER, attemptsString));
        } while ((tmpDir = new File(parentTempDir, PREFIX + UUID.randomUUID().toString())).exists());
        if (tmpDir.mkdirs()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Temporary work folder for deploy client: " + tmpDir.getAbsolutePath()));
            }
            return tmpDir;
        }
        LOGGER.error((Object)String.format(LOGGING_ERROR_CREATING_FOLDER, tmpDir.getAbsoluteFile()));
        throw new DeployServiceException(String.format(EXCEPTION_MESSAGE_CREATING_FOLDER, tmpDir.getAbsolutePath()));
    }

    public static File[] listTempDirectories() {
        return DEPLOY_TEMP_DIR.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(DeploymentUtils.PREFIX);
            }
        });
    }

    public void deleteDirectory_NonStaticCall(File dir) {
        DeploymentUtils.deleteDirectory(dir);
    }

    public static void deleteDirectory(File dir) {
        File[] files;
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting removal of directory [" + dir + "]"));
        }
        if ((files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    DeploymentUtils.deleteDirectory(file);
                } else {
                    DeploymentUtils.tryToDeleteAndReport(file);
                }
                ++n2;
            }
        }
        DeploymentUtils.tryToDeleteAndReport(dir);
    }

    private static void tryToDeleteAndReport(File file) {
        if (file.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(String.valueOf(file.getAbsolutePath()) + " was deleted"));
            }
        } else {
            LOGGER.warn((Object)(String.valueOf(file.getAbsolutePath()) + " was not deleted"));
        }
    }
}

