/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.rest.entity.request.FileEntry;
import com.sap.core.deploy.commons.rest.entity.request.FileRequest;
import com.sap.core.deploy.commons.util.CheckSumAttributes;
import com.sap.core.deploy.commons.util.CustomDigestInputStream;
import com.sap.core.deploy.commons.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class FileRequestFactory {
    public static final String ORIGINAL_ZIP_EXTENSION = ".original";
    private static final Logger LOGGER = Logger.getLogger(FileRequestFactory.class);
    private static final String HEX_ALGORITHM = "SHA-512";
    private static final String HEX_PARAM = "%02x";
    private static final int BUFFER_SIZE = 8192;

    public static FileRequest createFileRequest(File file) throws IOException {
        FileRequest fileRequest = new FileRequest(file.getName());
        CheckSumAttributes checkSumAttributes = FileRequestFactory.calculateHashAndSize(file);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("File [%s] has size [%s] and hash [%s]", file.getAbsolutePath(), checkSumAttributes.getSize(), checkSumAttributes.getHash()));
        }
        fileRequest.setSize(checkSumAttributes.getSize());
        fileRequest.setHash(checkSumAttributes.getHash());
        FileRequestFactory.populateFileEntries(fileRequest, file);
        return fileRequest;
    }

    private static void populateFileEntries(FileRequest fileRequest, File aFile) throws IOException {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        try (ZipFile zipFile = new ZipFile(aFile);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                InputStream zipEntryInputStream = zipFile.getInputStream(zipEntry);
                CheckSumAttributes checkSumAttributes = FileRequestFactory.calculateHashAndSize(zipEntryInputStream);
                FileEntry fileEntry = new FileEntry(zipEntry.getName(), checkSumAttributes.getSize(), checkSumAttributes.getHash());
                entries.add(fileEntry);
            }
            fileRequest.setEntries(entries);
        }
    }

    private static CheckSumAttributes calculateHashAndSize(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            CheckSumAttributes checkSumAttributes = FileRequestFactory.calculateHashAndSize(fileInputStream);
            return checkSumAttributes;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    private static CheckSumAttributes calculateHashAndSize(InputStream inputStream) throws IOException {
        byte[] dataBytes = new byte[8192];
        int read = 0;
        int totalSize = 0;
        MessageDigest messageDigest = FileRequestFactory.getMD();
        DigestInputStream dis = new DigestInputStream(inputStream, messageDigest);
        while ((read = dis.read(dataBytes)) != -1) {
            totalSize += read;
        }
        String hash = FileRequestFactory.byteArray2Hex(messageDigest.digest());
        return new CheckSumAttributes(totalSize, hash);
    }

    public static MessageDigest getMD() {
        try {
            return MessageDigest.getInstance(HEX_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.fatal((Object)"Failed getting MD", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String byteArray2Hex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format(HEX_PARAM, b);
                ++n2;
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static FileRequest createFileRequestWhileStreaming(String path, InputStream is, OutputStream os, long transferByteLimit) throws IOException, NoSuchAlgorithmException, InterruptedException {
        return FileRequestFactory.createFileRequestWhileStreaming(path, is, os, transferByteLimit, true);
    }

    public static FileRequest createFileRequestWhileStreaming(String path, InputStream is, OutputStream os, long transferByteLimit, boolean closeInputStream) throws IOException, NoSuchAlgorithmException, InterruptedException {
        final FileRequest fileRequest = new FileRequest(path);
        final PipedInputStream pis = new PipedInputStream(16384);
        final PipedOutputStream pos = new PipedOutputStream();
        pis.connect(pos);
        Thread hashCalculationThread = new Thread(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[8192];
                    int bytesRead = 0;
                    String zipHash = null;
                    MessageDigest md = FileRequestFactory.getMD();
                    CustomDigestInputStream cdis = new CustomDigestInputStream(pis, md);
                    ZipInputStream zis = new ZipInputStream(cdis);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zis.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        CheckSumAttributes checkSumAttributes = FileRequestFactory.calculateHashAndSize(zis);
                        FileEntry fileEntry = new FileEntry(zipEntry.getName(), checkSumAttributes.getSize(), checkSumAttributes.getHash());
                        fileRequest.getEntries().add(fileEntry);
                    }
                    while (bytesRead >= 0) {
                        bytesRead = cdis.read(buffer);
                    }
                    zipHash = FileRequestFactory.byteArray2Hex(md.digest());
                    fileRequest.setHash(zipHash);
                    fileRequest.setSize(cdis.getSize());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)e);
                    IOUtils.closeQuietly(pos);
                }
            }
        };
        hashCalculationThread.start();
        IOUtils.copyStream(is, os, pos, transferByteLimit, closeInputStream);
        hashCalculationThread.join();
        return fileRequest;
    }
}

