/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.commons.util;

import com.sap.core.deploy.commons.rest.entity.request.FileRequest;
import com.sap.core.deploy.commons.util.DeploymentUtils;
import com.sap.core.deploy.commons.util.FileRequestFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class IOUtils {
    private static final Logger LOGGER = Logger.getLogger(IOUtils.class);
    private static final int BUFFER = 8192;
    public static final String UTF_8 = "UTF-8";
    private static final String DESCRIPTOR_JSON = "descriptor.json";

    public static File createFileSecured(File dir, String fileName) throws IOException {
        File file = new File(dir, fileName);
        if (file.getCanonicalPath().startsWith(dir.getCanonicalPath())) {
            return file;
        }
        throw new IOException(String.format("Malicious file name [%1$s] detected", fileName));
    }

    public static File createFileSecured(String dir, String fileName) throws IOException {
        return IOUtils.createFileSecured(new File(dir), fileName);
    }

    public static long unzip(InputStream in, File destinationDir, long transferByteLimit) throws IOException {
        return IOUtils.unzip(in, destinationDir, transferByteLimit, false);
    }

    /*
     * Unable to fully structure code
     */
    public static long unzip(InputStream in, File destinationDir, long transferByteLimit, boolean shouldReadStreamToTheEnd) throws IOException {
        chunk = new byte[8192];
        totalBytesRead = 0L;
        bis = new BufferedInputStream(in, 8192);
        zin = new ZipInputStream(bis);
        try {
            if (IOUtils.LOGGER.isDebugEnabled()) {
                IOUtils.LOGGER.debug((Object)("Starting extraction of archived update site from the request body to directory " + destinationDir));
            }
            destinationPath = destinationDir.getCanonicalPath();
            while ((zipEntry = zin.getNextEntry()) != null) {
                block17: {
                    if (IOUtils.LOGGER.isDebugEnabled()) {
                        IOUtils.LOGGER.debug((Object)("Extracting " + zipEntry));
                    }
                    name = zipEntry.getName();
                    unzippedFile = IOUtils.createFileSecured(destinationPath, name).getCanonicalFile();
                    if (zipEntry.isDirectory()) continue;
                    parentFolder = unzippedFile.getParentFile();
                    if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                        throw new IOException(String.format(DeploymentUtils.EXCEPTION_MESSAGE_CREATING_FOLDER, new Object[]{parentFolder.getAbsolutePath()}));
                    }
                    out = new BufferedOutputStream(new FileOutputStream(unzippedFile), 8192);
                    try {
                        try {
                            if (transferByteLimit >= 0L) ** GOTO lbl30
                            while ((count = zin.read(chunk, 0, 8192)) != -1) {
                                totalBytesRead += (long)count;
                                out.write(chunk, 0, count);
                            }
                            break block17;
lbl-1000:
                            // 1 sources

                            {
                                if ((totalBytesRead += (long)count) > transferByteLimit) {
                                    throw new SecurityException("The maximum number of bytes allowed for unzipped content is " + transferByteLimit);
                                }
                                out.write(chunk, 0, count);
lbl30:
                                // 2 sources

                                ** while ((count = zin.read((byte[])chunk, (int)0, (int)8192)) != -1)
                            }
lbl31:
                            // 1 sources

                        }
                        catch (EOFException eof) {
                            IOUtils.LOGGER.error((Object)eof.getMessage());
                            out.close();
                            continue;
                        }
                    }
                    catch (Throwable var18_16) {
                        out.close();
                        throw var18_16;
                    }
                }
                out.close();
            }
            if (IOUtils.LOGGER.isDebugEnabled()) {
                IOUtils.LOGGER.debug((Object)("Archived update site was successfully extracted to directory " + destinationDir));
            }
        }
        finally {
            if (shouldReadStreamToTheEnd) {
                IOUtils.LOGGER.debug((Object)"Reading original input stream to the end after processing it as a zip input stream");
                IOUtils.readEntirely(bis);
            }
            if (IOUtils.LOGGER.isDebugEnabled()) {
                IOUtils.LOGGER.debug((Object)("Closing ZIP input stream and the underlying input stream [" + in + "]"));
            }
            zin.close();
        }
        return totalBytesRead;
    }

    public static Map<String, FileRequest> unzipAndCalculateHashes(InputStream in, File destinationDir, long transferByteLimit, boolean shouldReadStreamToTheEnd) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in, 8192);
        ZipInputStream zin = new ZipInputStream(bis);
        HashMap<String, FileRequest> filesRequestMap = new HashMap<String, FileRequest>();
        try {
            ZipEntry zipEntry;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Starting extraction of archived update site from the request body to directory " + destinationDir));
            }
            String destinationPath = destinationDir.getCanonicalPath();
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Extracting " + zipEntry));
                }
                String name = zipEntry.getName();
                File unzippedFile = IOUtils.createFileSecured(destinationPath, name).getCanonicalFile();
                if (zipEntry.isDirectory()) continue;
                File parentFolder = unzippedFile.getParentFile();
                if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                    throw new IOException(String.format(DeploymentUtils.EXCEPTION_MESSAGE_CREATING_FOLDER, parentFolder.getAbsolutePath()));
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(unzippedFile), 8192);
                try {
                    try {
                        if (DESCRIPTOR_JSON.equals(name)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Extracting " + zipEntry + " and calculation of hashes will be skipped"));
                            }
                            IOUtils.copyStream(zin, out, null, transferByteLimit, false);
                        } else {
                            FileRequest fileRequest = FileRequestFactory.createFileRequestWhileStreaming(name, zin, out, transferByteLimit, false);
                            filesRequestMap.put(fileRequest.getHash(), fileRequest);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage());
                        ((OutputStream)out).close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Archived update site was successfully extracted to directory " + destinationDir));
            }
        }
        finally {
            if (shouldReadStreamToTheEnd) {
                LOGGER.debug((Object)"Reading original input stream to the end after processing it as a zip input stream");
                IOUtils.readEntirely(bis);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Closing ZIP input stream and the underlying input stream [" + in + "]"));
            }
            zin.close();
        }
        return filesRequestMap;
    }

    public static void readEntirely(InputStream is) {
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            int totalBytesRead = 0;
            while (bytesRead >= 0) {
                totalBytesRead += bytesRead;
                bytesRead = is.read(buffer);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[" + totalBytesRead + "] bytes are read from input stream"));
            }
        }
        catch (IOException t) {
            LOGGER.error((Object)"Error while reading from input stream", (Throwable)t);
        }
    }

    public static void zip(File directory, OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Creating zip from directory " + directory));
        }
        IOUtils.addDirectoryToZip(zipOutputStream, directory, "");
        zipOutputStream.finish();
    }

    public static String readableSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Received negative value - " + size + ", as a file size for deployment batch");
        }
        if (size == 0L) {
            return "0 B";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = 1;
        return String.valueOf(new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups))) + " " + units[digitGroups];
    }

    private static void addDirectoryToZip(ZipOutputStream outputStream, File directory, String pathPrefix) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                name = String.valueOf(pathPrefix) + file.getName() + "/";
                ZipEntry dirEntry = new ZipEntry(name);
                dirEntry.setTime(file.lastModified());
                outputStream.putNextEntry(dirEntry);
                outputStream.closeEntry();
                IOUtils.addDirectoryToZip(outputStream, file, name);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding file to zip stream " + file));
                }
                name = String.valueOf(pathPrefix) + file.getName();
                ZipEntry fileEntry = new ZipEntry(name);
                fileEntry.setTime(file.lastModified());
                outputStream.putNextEntry(fileEntry);
                try (FileInputStream inputStream = null;){
                    inputStream = new FileInputStream(file);
                    IOUtils.copyStream(inputStream, outputStream, -1L);
                }
                outputStream.closeEntry();
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String readToString(InputStream inputStream, long transferByteLimit) throws IOException {
        block9: {
            if (inputStream == null) {
                return "";
            }
            stringBuilder = new StringBuilder();
            bufferedReader = null;
            inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                charBuffer = new char[4096];
                totalBytesRead = 0L;
                if (transferByteLimit >= 0L) ** GOTO lbl21
                while ((bytesRead = bufferedReader.read(charBuffer)) >= 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    if ((totalBytesRead += (long)bytesRead) > transferByteLimit) {
                        throw new SecurityException("The maximum number of bytes allowed for transfer into string is " + transferByteLimit);
                    }
                    stringBuilder.append(charBuffer, 0, bytesRead);
lbl21:
                    // 2 sources

                    ** while ((bytesRead = bufferedReader.read((char[])charBuffer)) >= 0)
                }
lbl22:
                // 1 sources

            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return stringBuilder.toString();
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, long transferByteLimit) throws IOException {
        return IOUtils.copyStream(inputStream, outputStream, null, transferByteLimit);
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, PipedOutputStream pipedOutputStream, long transferByteLimit) throws IOException {
        return IOUtils.copyStream(inputStream, outputStream, pipedOutputStream, transferByteLimit, true);
    }

    /*
     * Unable to fully structure code
     */
    public static long copyStream(InputStream inputStream, OutputStream outputStream, PipedOutputStream pipedOutputStream, long transferByteLimit, boolean closeInputStream) throws IOException {
        block8: {
            chunk = new byte[8192];
            totalBytesRead = 0L;
            try {
                if (transferByteLimit >= 0L) ** GOTO lbl17
                while ((bytesRead = inputStream.read(chunk)) >= 0) {
                    totalBytesRead += (long)bytesRead;
                    outputStream.write(chunk, 0, bytesRead);
                    if (pipedOutputStream == null) continue;
                    pipedOutputStream.write(chunk, 0, bytesRead);
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    if ((totalBytesRead += (long)bytesRead) > transferByteLimit) {
                        throw new SecurityException("The maximum number of bytes allowed to be copied from inputStream to outputStream is " + transferByteLimit);
                    }
                    outputStream.write(chunk, 0, bytesRead);
                    if (pipedOutputStream == null) continue;
                    pipedOutputStream.write(chunk, 0, bytesRead);
lbl17:
                    // 3 sources

                    ** while ((bytesRead = inputStream.read((byte[])chunk)) >= 0)
                }
lbl18:
                // 1 sources

            }
            finally {
                if (closeInputStream) {
                    inputStream.close();
                }
                if (pipedOutputStream != null) {
                    pipedOutputStream.close();
                }
            }
        }
        return totalBytesRead;
    }

    public static void closeQuietly(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

